/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.Comparator;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.ItemColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.ItemFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.ItemFieldAccessorAdapter;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueFormatter;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorCache;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.rule.RulePriority;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.graphics.Image;

public final class MarkerColumnsUI {
    public static final Comparator<RulePriority> COMP_PRIORITY = new Comparator<RulePriority>(){

        @Override
        public int compare(RulePriority a, RulePriority b) {
            return a.compareTo((Enum)b);
        }
    };
    public static final ItemFieldAccessor<RulePriority, IMarker> PRIORITY_ACC = new ItemFieldAccessorAdapter<RulePriority, IMarker>(COMP_PRIORITY){

        @Override
        public RulePriority valueFor(IMarker marker) {
            int prio = MarkerUtil.rulePriorityFor(marker, 1);
            return RulePriority.valueOf((int)prio);
        }
    };
    public static final ItemFieldAccessor<Image, IMarker> PRIORITY_IMG_ACC = new ItemFieldAccessorAdapter<Image, IMarker>(null){

        @Override
        public Image imageFor(IMarker marker) {
            RulePriority rp = PRIORITY_ACC.valueFor(marker);
            return PriorityDescriptorCache.INSTANCE.descriptorFor(rp).getAnnotationImage();
        }
    };
    public static final ItemFieldAccessor<Integer, IMarker> LINE_NO_ACC = new ItemFieldAccessorAdapter<Integer, IMarker>(Util.COMP_INT){

        @Override
        public Integer valueFor(IMarker marker) {
            return marker.getAttribute("lineNumber", 0);
        }
    };
    public static final ItemFieldAccessor<Long, IMarker> CREATED_ACC = new ItemFieldAccessorAdapter<Long, IMarker>(Util.COMP_LONG){

        @Override
        public Long valueFor(IMarker marker) {
            return MarkerUtil.createdOn(marker, -1L);
        }
    };
    public static final ItemFieldAccessor<Boolean, IMarker> DONE_ACC = new ItemFieldAccessorAdapter<Boolean, IMarker>(Util.COMP_BOOL){

        @Override
        public Boolean valueFor(IMarker marker) {
            return MarkerUtil.doneState(marker, false);
        }
    };
    public static final ItemFieldAccessor<String, IMarker> RULE_NAME_ACC = new ItemFieldAccessorAdapter<String, IMarker>(Util.COMP_STR){

        @Override
        public String valueFor(IMarker marker) {
            return MarkerUtil.ruleNameFor(marker);
        }
    };
    public static final ItemFieldAccessor<String, IMarker> MESSAGE_ACC = new ItemFieldAccessorAdapter<String, IMarker>(Util.COMP_STR){

        @Override
        public String valueFor(IMarker marker) {
            return MarkerUtil.messageFor(marker, "??");
        }
    };
    public static final ItemColumnDescriptor<Image, IMarker> PRIORITY = new ItemColumnDescriptor<Image, IMarker>("tPriority", "Priority", 0x1000000, 20, false, PRIORITY_IMG_ACC);
    public static final ItemColumnDescriptor<Boolean, IMarker> DONE = new ItemColumnDescriptor<Boolean, IMarker>("tDone", "done", 16384, 50, false, DONE_ACC);
    public static final ItemColumnDescriptor<Long, IMarker> CREATED = new ItemColumnDescriptor<Long, IMarker>("tCreated", "created", 16384, 130, true, CREATED_ACC, ValueFormatter.TIME_FORMATTERS);
    public static final ItemColumnDescriptor<String, IMarker> RULE_NAME = new ItemColumnDescriptor<String, IMarker>("tRuleName", "Rule", 16384, 190, true, RULE_NAME_ACC);
    public static final ItemColumnDescriptor<String, IMarker> MESSAGE = new ItemColumnDescriptor<String, IMarker>("tMsg", "view.outline.column_message", 16384, 260, true, MESSAGE_ACC);
    public static final ItemColumnDescriptor<Integer, IMarker> LINE_NUMBER = new ItemColumnDescriptor<Integer, IMarker>("tLineNo", "view.outline.column_line", 16384, 50, false, LINE_NO_ACC);

    private MarkerColumnsUI() {
    }
}

