/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicRuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.eclipse.ui.quickfix.PMDResolutionGenerator;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.properties.PropertySource;

public interface RuleFieldAccessor {
    public static final String[] RULE_TYPE_GENERIC = new String[]{"-", "Generic"};
    public static final String[] RULE_TYPE_XPATH = new String[]{"X", "XPath"};
    public static final RuleFieldAccessor SINCE = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getSince();
        }
    };
    public static final RuleFieldAccessor PRIORITY = new BasicRuleFieldAccessor(){

        @Override
        public Comparable<?> valueFor(Rule rule) {
            return rule.getPriority();
        }

        @Override
        public String labelFor(Rule rule) {
            return UISettings.labelFor(rule.getPriority());
        }

        @Override
        public Comparable<?> valueFor(RuleCollection collection) {
            return RuleUtil.commonPriority(collection);
        }
    };
    public static final RuleFieldAccessor PRIORITY_NAME = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return UISettings.labelFor(rule.getPriority());
        }
    };
    public static final RuleFieldAccessor FIX_COUNT = new BasicRuleFieldAccessor(){

        public Comparable<Integer> valueFor(Rule rule) {
            return PMDResolutionGenerator.fixCountFor(rule);
        }
    };
    public static final RuleFieldAccessor NAME = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getName();
        }
    };
    public static final RuleFieldAccessor DESCRIPTION = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getDescription();
        }
    };
    public static final RuleFieldAccessor MESSAGE = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getMessage();
        }
    };
    public static final RuleFieldAccessor URL = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getExternalInfoUrl();
        }
    };
    public static final RuleFieldAccessor EXAMPLE_COUNT = new BasicRuleFieldAccessor(){

        @Override
        public Comparable<?> valueFor(Rule rule) {
            int count = rule.getExamples().size();
            return count > 0 ? Integer.toString(count) : "";
        }
    };
    public static final RuleFieldAccessor RULE_TYPE = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            StringBuilder sb = new StringBuilder();
            if (RuleUtil.isXPathRule((PropertySource)rule)) {
                sb.append(RULE_TYPE_XPATH[0]);
            }
            if (sb.length() == 0) {
                sb.append(RULE_TYPE_GENERIC[0]);
            }
            return sb.toString();
        }

        @Override
        public String labelFor(Rule rule) {
            ArrayList<String> types = new ArrayList<String>();
            if (RuleUtil.isXPathRule((PropertySource)rule)) {
                types.add(RULE_TYPE_XPATH[0]);
            }
            if (types.isEmpty()) {
                types.add(RULE_TYPE_GENERIC[0]);
            }
            return Util.asString(types, ", ");
        }
    };
    public static final RuleFieldAccessor LANGUAGE = new BasicRuleFieldAccessor(){

        public Comparable<Language> valueFor(Rule rule) {
            return rule.getLanguage();
        }

        @Override
        public String labelFor(Rule rule) {
            return rule.getLanguage().getName();
        }
    };
    public static final RuleFieldAccessor MIN_LANGUAGE_VERSION = new BasicRuleFieldAccessor(){

        public Comparable<LanguageVersion> valueFor(Rule rule) {
            return rule.getMinimumLanguageVersion();
        }
    };
    public static final RuleFieldAccessor MAX_LANGUAGE_VERSION = new BasicRuleFieldAccessor(){

        public Comparable<LanguageVersion> valueFor(Rule rule) {
            return rule.getMaximumLanguageVersion();
        }
    };
    public static final RuleFieldAccessor VIOLATION_REGEX = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return (Comparable)((Object)((Optional)rule.getProperty(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR)).map(Pattern::toString).orElse(""));
        }
    };
    public static final RuleFieldAccessor VIOLATION_XPATH = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return (Comparable)((Object)((Optional)rule.getProperty(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR)).orElse(""));
        }
    };
    public static final RuleFieldAccessor NON_DEFAULT_PROPERTY_COUNT = new BasicRuleFieldAccessor(){

        public Comparable<Integer> valueFor(Rule rule) {
            return RuleUtil.modifiedPropertiesIn(rule).size();
        }
    };

    public Comparable<?> valueFor(Rule var1);

    public Comparable<?> valueFor(RuleCollection var1);

    public Set<Comparable<?>> uniqueValuesFor(RuleCollection var1);

    public String labelFor(Rule var1);
}

