/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleVisitor;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import org.apache.commons.lang3.StringUtils;

public class RuleGroup<T extends Comparable<T>>
implements RuleCollection,
Comparable<RuleGroup<T>> {
    private T id;
    private String label;
    private String description;
    private List<Rule> rules = new ArrayList<Rule>();

    public RuleGroup(T theId, String theLabel, String theDescription) {
        this.id = theId;
        this.label = theLabel;
        this.description = theDescription;
    }

    @Override
    public boolean isEmpty() {
        return this.rules == null || this.rules.isEmpty();
    }

    @Override
    public Rule soleRule() {
        return this.rules.size() == 1 ? this.rules.get(0) : null;
    }

    @Override
    public boolean rulesDo(RuleVisitor visitor) {
        for (Rule rule : this.rules) {
            if (visitor.accept(rule)) continue;
            return false;
        }
        return true;
    }

    public T id() {
        return this.id;
    }

    public String description() {
        return this.description;
    }

    public String label() {
        if (this.label != null) {
            return this.label;
        }
        return this.id == null ? "" : this.id.toString();
    }

    public void sortBy(Comparator<Rule> ruleComparator) {
        if (!this.hasRules()) {
            return;
        }
        Collections.sort(this.rules, ruleComparator);
    }

    public int ruleCount() {
        return this.rules.size();
    }

    public void add(Rule ref) {
        this.rules.add(ref);
    }

    public Rule[] rules() {
        return this.rules.toArray(new Rule[0]);
    }

    public <P> String commonStringProperty(PropertyDescriptor<P> desc) {
        if (this.rules.isEmpty()) {
            return null;
        }
        String value = desc.serializer().toString(this.rules.get(0).getProperty(desc));
        int i = 1;
        while (i < this.rules.size()) {
            String other = desc.serializer().toString(this.rules.get(i).getProperty(desc));
            if (!StringUtils.equals((CharSequence)StringUtils.stripToNull((String)other), (CharSequence)StringUtils.stripToNull((String)value))) {
                return null;
            }
            ++i;
        }
        return value;
    }

    public boolean hasRules() {
        return !this.rules.isEmpty();
    }

    public String toString() {
        return String.valueOf(this.label()) + " rules: " + this.ruleCount();
    }

    @Override
    public int compareTo(RuleGroup<T> otherGroup) {
        if (this.id == null) {
            return -1;
        }
        if (otherGroup.id() == null) {
            return -1;
        }
        return this.id.compareTo(otherGroup.id());
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleGroup other = (RuleGroup)obj;
        return Objects.equals(this.id, other.id);
    }
}

