/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import net.sourceforge.pmd.eclipse.ui.preferences.AbstractTableLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleGroup;
import net.sourceforge.pmd.lang.rule.Rule;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Image;

public class RuleLabelProvider
extends AbstractTableLabelProvider {
    private RuleColumnDescriptor[] columnDescriptors;

    public RuleLabelProvider(RuleColumnDescriptor[] columns) {
        this.columnDescriptors = columns;
    }

    public String getDetailText(Object element, int columnIndex) {
        if (columnIndex <= 0) {
            return "";
        }
        if (element instanceof Rule) {
            Rule rule = (Rule)element;
            String problem = rule.dysfunctionReason();
            if (StringUtils.isNotBlank((CharSequence)problem)) {
                return "Problem in " + rule.getName() + " rule: " + problem;
            }
            return this.columnDescriptors[columnIndex - 1].detailStringFor(rule);
        }
        if (element instanceof RuleGroup) {
            RuleGroup group = (RuleGroup)element;
            return this.columnDescriptors[columnIndex - 1].detailStringFor(group);
        }
        return "??";
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex <= 0) {
            return "";
        }
        if (element instanceof RuleCollection) {
            if (columnIndex == 1) {
                RuleGroup rg = (RuleGroup)element;
                String label = rg.label();
                return this.standardized(label, rg.ruleCount());
            }
            return this.columnDescriptors[columnIndex - 1].stringValueFor((RuleCollection)element);
        }
        if (element instanceof Rule) {
            RuleColumnDescriptor rcd = this.columnDescriptors[columnIndex - 1];
            String text = rcd.stringValueFor((Rule)element);
            return columnIndex == 1 ? "   " + text : text;
        }
        return "??";
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex <= 0) {
            return null;
        }
        if (element instanceof RuleCollection) {
            return this.columnDescriptors[columnIndex - 1].imageFor((RuleCollection)element);
        }
        if (element instanceof Rule) {
            return this.columnDescriptors[columnIndex - 1].imageFor((Rule)element);
        }
        return null;
    }

    private String standardized(String rawLabel, int count) {
        int rulesPos = rawLabel.indexOf(" Rules");
        String filteredLabel = rulesPos > 0 ? rawLabel.substring(0, rulesPos) : rawLabel;
        return String.valueOf(filteredLabel) + "  (" + count + ")";
    }
}

