/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.eclipse.ui.IndexedString;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.Configuration;
import net.sourceforge.pmd.eclipse.util.FontBuilder;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySerializer;
import net.sourceforge.pmd.properties.PropertySource;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public final class RuleUIUtil {
    public static final Shape PRIORITY_SHAPE = Shape.diamond;
    public static final Shape REGEX_FILTER_SHAPE = Shape.square;
    public static final Shape XPATH_FILTER_SHAPE = Shape.circle;
    public static final FontBuilder BLUE_BOLD_11 = new FontBuilder("Tahoma", 11, 1, 9);
    public static final FontBuilder RED_BOLD_11 = new FontBuilder("Tahoma", 11, 1, 3);
    public static final FontBuilder CHANGED_PROPERTY_FONT = BLUE_BOLD_11;
    public static final VerifyListener RULE_NAME_VERIFIER = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.doit = false;
            char ch = event.character;
            String text = ((Text)event.widget).getText();
            if (Character.isDigit(ch) && text.length() == 0) {
                event.doit = false;
                return;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                event.doit = true;
            }
            if (ch == '\b') {
                event.doit = true;
            }
        }
    };
    public static final VerifyListener RULE_LABEL_VERIFIER = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.doit = false;
            char ch = event.character;
            String text = ((Text)event.widget).getText();
            if (Character.isWhitespace(ch) && text.length() == 0) {
                event.doit = false;
                return;
            }
            event.doit = true;
        }
    };

    private RuleUIUtil() {
    }

    public static String ruleSetNameFrom(Rule rule) {
        return RuleUIUtil.ruleSetNameFrom(rule.getRuleSetName());
    }

    public static String ruleSetNameFrom(String rulesetName) {
        int pos = rulesetName.toUpperCase(Locale.ROOT).indexOf("RULES");
        return pos < 0 ? rulesetName : rulesetName.substring(0, pos - 1);
    }

    private static int formatValueOn(StringBuilder target, Map.Entry<PropertyDescriptor<?>, Object> entry, String modifiedTag) {
        boolean isModified;
        PropertyDescriptor<?> property = entry.getKey();
        PropertySerializer serializer = property.serializer();
        Object value = entry.getValue();
        boolean bl = isModified = !RuleUtil.isDefaultValue(entry);
        if (isModified) {
            target.append(modifiedTag);
        }
        String output = serializer.toString(value);
        target.append(output);
        return isModified ? output.length() : 0;
    }

    public static String propertyStringFrom(Rule rule, String modifiedTag) {
        Map<PropertyDescriptor<?>, Object> valuesByProp = Configuration.filteredPropertiesOf((PropertySource)rule);
        if (valuesByProp.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(80);
        Iterator<Map.Entry<PropertyDescriptor<?>, Object>> iter = valuesByProp.entrySet().iterator();
        Map.Entry<PropertyDescriptor<?>, Object> entry = iter.next();
        sb.append(entry.getKey().name()).append(": ");
        RuleUIUtil.formatValueOn(sb, entry, modifiedTag);
        while (iter.hasNext()) {
            entry = iter.next();
            sb.append(", ").append(entry.getKey().name()).append(": ");
            RuleUIUtil.formatValueOn(sb, entry, modifiedTag);
        }
        return sb.toString();
    }

    public static IndexedString indexedPropertyStringFrom(Rule rule) {
        Map<PropertyDescriptor<?>, Object> valuesByProp = Configuration.filteredPropertiesOf((PropertySource)rule);
        if (valuesByProp.isEmpty()) {
            return IndexedString.EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<PropertyDescriptor<?>, Object>> iter = valuesByProp.entrySet().iterator();
        ArrayList<int[]> modifiedValueIndexes = new ArrayList<int[]>(valuesByProp.size());
        Map.Entry<PropertyDescriptor<?>, Object> entry = iter.next();
        sb.append(entry.getKey().name()).append(": ");
        int start = sb.length();
        int stop = start + RuleUIUtil.formatValueOn(sb, entry, "");
        if (stop > start) {
            modifiedValueIndexes.add(new int[]{start, stop});
        }
        while (iter.hasNext()) {
            entry = iter.next();
            sb.append(", ").append(entry.getKey().name()).append(": ");
            start = sb.length();
            stop = start + RuleUIUtil.formatValueOn(sb, entry, "");
            if (stop <= start) continue;
            modifiedValueIndexes.add(new int[]{start, stop});
        }
        return new IndexedString(sb.toString(), modifiedValueIndexes);
    }
}

