/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.Date;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicValueFormatter;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.RulePriority;

public interface ValueFormatter {
    public static final ValueFormatter STRING_FORMATTER = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "" : value);
        }

        @Override
        public String format(Object value) {
            return value == null ? "" : value.toString();
        }
    };
    public static final ValueFormatter MULTI_STRING_FORMATTER = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append('[');
            Util.asString((Object[])value, ", ", target);
            target.append(']');
        }
    };
    public static final ValueFormatter NUMBER_FORMATTER = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "?" : value);
        }
    };
    public static final ValueFormatter BOOLEAN_FORMATTER = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "?" : value);
        }
    };
    public static final ValueFormatter TYPE_FORMATTER = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "" : ((Class)value).getName());
        }
    };
    public static final ValueFormatter OBJECT_FORMATTER = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append(value == null ? "" : value);
        }
    };
    public static final ValueFormatter OBJECT_ARRAY_FORMATTER = new BasicValueFormatter(null){

        @Override
        public void format(Object value, StringBuilder target) {
            target.append('[');
            Util.asString((Object[])value, ", ", target);
            target.append(']');
        }
    };
    public static final ValueFormatter PRIORITY_FORMATTER = new BasicValueFormatter(null){

        @Override
        public String format(Object value) {
            return UISettings.labelFor((RulePriority)value);
        }
    };
    public static final ValueFormatter LANGUAGE_FORMATTER = new BasicValueFormatter(null){

        @Override
        public String format(Object value) {
            return ((Language)value).getName();
        }
    };
    public static final ValueFormatter LANGUAGE_VERSION_FORMATTER = new BasicValueFormatter(null){

        @Override
        public String format(Object value) {
            return ((LanguageVersion)value).getName();
        }
    };
    public static final ValueFormatter DATE_FROM_LONG_FORMATTER = new BasicValueFormatter("Date"){

        @Override
        public String format(Object value) {
            return new Date((Long)value).toString();
        }
    };
    public static final ValueFormatter TIME_FROM_LONG_FORMATTER = new BasicValueFormatter("Time"){

        @Override
        public String format(Object value) {
            return new Date((Long)value).toString();
        }
    };
    public static final ValueFormatter[] TIME_FORMATTERS = new ValueFormatter[]{DATE_FROM_LONG_FORMATTER};

    public String format(Object var1);

    public void format(Object var1, StringBuilder var2);
}

