/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.lang.reflect.Method;
import java.util.Arrays;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.TypeText;
import net.sourceforge.pmd.eclipse.util.Util;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

@Deprecated
public class MethodPicker
extends Composite {
    private TypeText typeText;
    private Combo methodList;
    private Method[] methods;
    private String[] unwantedPrefixes;

    public MethodPicker(Composite parent, int style, String[] theUnwantedPrefixes) {
        super(parent, 0);
        this.unwantedPrefixes = theUnwantedPrefixes == null ? new String[]{} : theUnwantedPrefixes;
        GridLayout layout = new GridLayout(2, true);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.typeText = new TypeText(this, style, false, "Enter a type name");
        this.typeText.setLayoutData(new GridData(768));
        this.typeText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                MethodPicker.this.reviseMethodListFor(MethodPicker.this.typeText.getType(true));
            }
        });
        this.typeText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                MethodPicker.this.reviseMethodListFor(MethodPicker.this.typeText.getType(false));
            }
        });
        this.methodList = new Combo((Composite)this, style);
        this.methodList.setLayoutData((Object)new GridData(1808));
    }

    private void reviseMethodListFor(Class<?> cls) {
        if (cls == null) {
            this.methodList.removeAll();
            this.methodList.setEnabled(false);
            return;
        }
        this.methodList.setEnabled(true);
        this.methods = cls.getMethods();
        Arrays.sort(this.methods, Util.METHOD_NAME_COMPARATOR);
        String[] items = new String[this.methods.length];
        int i = 0;
        while (i < this.methods.length) {
            items[i] = Util.signatureFor(this.methods[i], this.unwantedPrefixes);
            ++i;
        }
        this.methodList.setItems(items);
        this.methodList.select(0);
    }

    public void setBackground(Color clr) {
        this.typeText.setBackground(clr);
        this.methodList.setBackground(clr);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point pt = this.typeText.computeSize(wHint, hHint, changed);
        pt.x *= 2;
        pt.y += 2;
        return pt;
    }

    public void setType(Class<?> cls) {
        this.typeText.setType(cls);
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.typeText.setEnabled(flag);
        this.methodList.setEnabled(flag);
    }

    public void setEditable(boolean flag) {
        this.typeText.setEditable(flag);
    }

    public Class<?> getType(boolean doCleanup) {
        return this.typeText.getType(doCleanup);
    }

    private int indexOf(Method method) {
        if (this.methods == null) {
            return -1;
        }
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].equals(method)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setMethod(Method method) {
        if (method == null) {
            this.typeText.setType(null);
            return;
        }
        Class<?> cls = method.getDeclaringClass();
        this.typeText.setType(cls);
        this.reviseMethodListFor(cls);
        this.methodList.select(this.indexOf(method));
    }

    public Method getMethod() {
        return this.methods == null ? null : this.methods[this.methodList.getSelectionIndex()];
    }

    public void addSelectionListener(SelectionListener listener) {
        this.methodList.addSelectionListener(listener);
    }
}

