/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.internal;

import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.internal.AbstractEditorFactory;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.PropertySource;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public final class PropertyEditorFactory
extends AbstractEditorFactory {
    public static final PropertyEditorFactory INSTANCE = new PropertyEditorFactory();

    private PropertyEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)name).desc(description)).defaultValue((Object)(otherData == null ? "" : this.valueFrom(otherData[1])))).build();
    }

    protected String valueFrom(Control valueControl) {
        return ((Text)valueControl).getText();
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        this.fillWidget(text, desc, source);
        text.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                String newValue = text.getText().trim();
                Object existingValueReal = PropertyEditorFactory.this.valueFor(source, desc);
                String existingValue = desc.serializer().toString(existingValueReal);
                if (StringUtils.equals((CharSequence)StringUtils.trimToNull((String)existingValue), (CharSequence)StringUtils.trimToNull((String)newValue))) {
                    return;
                }
                PropertyEditorFactory.this.setValue(source, desc, newValue);
                PropertyEditorFactory.this.fillWidget(text, desc, source);
                listener.changed(source, desc, (Object)newValue);
            }
        });
        return text;
    }

    protected void fillWidget(Text textWidget, PropertyDescriptor desc, PropertySource source) {
        Object realVal = this.valueFor(source, desc);
        String val = desc.serializer().toString(realVal);
        textWidget.setText(val == null ? "" : val);
    }

    private void setValue(PropertySource source, PropertyDescriptor desc, String value) {
        if (!source.hasDescriptor(desc)) {
            return;
        }
        Object realValue = desc.serializer().fromString(value);
        source.setProperty(desc, realValue);
    }
}

