/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.DescriptionPanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.ExamplePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.ExclusionPanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.PerRulePropertyPanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.QuickFixPanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.RulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.RuleTarget;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.XPathPanelManager;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;

public class CreateRuleWizard
extends Wizard
implements ValueChangeListener,
RuleTarget {
    private Rule rule;
    private WizardDialog dialog;

    public void dialog(WizardDialog theDialog) {
        this.dialog = theDialog;
    }

    public Rule rule() {
        return this.rule;
    }

    @Override
    public void rule(Rule theRule) {
        this.rule = theRule;
        this.dialog.updateButtons();
    }

    public void addPages() {
        this.addPage((IWizardPage)new RulePanelManager("rule", EditorUsageMode.CreateNew, this, this));
        this.addPage((IWizardPage)new DescriptionPanelManager("description", EditorUsageMode.CreateNew, this));
        this.addPage((IWizardPage)new PerRulePropertyPanelManager("properties", EditorUsageMode.CreateNew, this));
        this.addPage((IWizardPage)new XPathPanelManager("xpath", EditorUsageMode.CreateNew, this));
        this.addPage((IWizardPage)new ExclusionPanelManager("exclusion", EditorUsageMode.CreateNew, this, false));
        this.addPage((IWizardPage)new ExamplePanelManager("examples", EditorUsageMode.CreateNew, this));
    }

    public boolean performFinish() {
        return true;
    }

    private boolean isXPathRule() {
        return RuleUtil.isXPathRule((PropertySource)this.rule);
    }

    public boolean performCancel() {
        System.out.println("Perform Cancel called");
        return true;
    }

    private IWizardPage getAndPrepare(String pageId) {
        AbstractRulePanelManager rulePanel = (AbstractRulePanelManager)this.getPage(pageId);
        RuleSelection rs = new RuleSelection(this.rule);
        rulePanel.manage(rs);
        return rulePanel;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (this.rule == null) {
            return null;
        }
        if (currentPage instanceof RulePanelManager) {
            return this.getAndPrepare("description");
        }
        if (currentPage instanceof DescriptionPanelManager) {
            if (StringUtils.isBlank((CharSequence)this.rule.getDescription())) {
                return null;
            }
            return this.getAndPrepare("perRuleProperties");
        }
        if (currentPage instanceof PerRulePropertyPanelManager) {
            return this.isXPathRule() ? this.getAndPrepare("xpath") : this.getAndPrepare("exclusion");
        }
        if (currentPage instanceof ExclusionPanelManager || currentPage instanceof XPathPanelManager) {
            return this.getAndPrepare("example");
        }
        if (currentPage instanceof QuickFixPanelManager) {
            return this.getAndPrepare("example");
        }
        return null;
    }

    @Override
    public void changed(RuleSelection rule, PropertyDescriptor<?> desc, Object newValue) {
    }

    @Override
    public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
    }
}

