/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.eclipse.util.internal.SWTUtil;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class DescriptionPanelManager
extends AbstractRulePanelManager {
    private Text descriptionBox;
    private Text externalURLField;
    private Label extURLLabel;
    private Button browseButton;
    private Label messageLabel;
    private Text messageField;
    public static final String ID = "description";

    public DescriptionPanelManager(String theTitle, EditorUsageMode theMode, ValueChangeListener theListener) {
        super(ID, theTitle, theMode, theListener);
    }

    @Override
    protected boolean canManageMultipleRules() {
        return false;
    }

    @Override
    protected void clearControls() {
        this.descriptionBox.setText("");
        this.externalURLField.setText("");
    }

    @Override
    public void showControls(boolean flag) {
        this.descriptionBox.setVisible(flag);
        this.externalURLField.setVisible(flag);
        this.browseButton.setVisible(flag);
        this.extURLLabel.setVisible(flag);
        this.messageLabel.setVisible(flag);
        this.messageField.setVisible(flag);
    }

    @Override
    protected void updateOverridenFields() {
        Rule rule = this.soleRule();
        if (rule instanceof RuleReference) {
            RuleReference ruleReference = (RuleReference)rule;
            this.messageField.setBackground((Color)(ruleReference.getOverriddenMessage() != null ? overridenColour : null));
            this.descriptionBox.setBackground((Color)(ruleReference.getOverriddenDescription() != null ? overridenColour : null));
            this.externalURLField.setBackground((Color)(ruleReference.getOverriddenExternalInfoUrl() != null ? overridenColour : null));
        }
    }

    @Override
    public Control setupOn(Composite parent) {
        this.initializeOn(parent);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        panel.setLayout((Layout)layout);
        this.descriptionBox = this.newTextField(panel);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.descriptionBox.setLayoutData((Object)gridData);
        this.descriptionBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Rule soleRule = DescriptionPanelManager.this.soleRule();
                if (soleRule == null) {
                    return;
                }
                String cleanValue = DescriptionPanelManager.this.asCleanString(DescriptionPanelManager.this.descriptionBox.getText());
                String existingValue = soleRule.getDescription();
                if (StringUtils.equals((CharSequence)StringUtils.stripToNull((String)existingValue), (CharSequence)StringUtils.stripToNull((String)cleanValue))) {
                    return;
                }
                soleRule.setDescription(cleanValue);
                DescriptionPanelManager.this.valueChanged(null, cleanValue);
                DescriptionPanelManager.this.validateRuleParams();
            }
        });
        this.buildExternalUrlPanel(panel, SWTUtil.stringFor("preference.ruleedit.label.external_info_url"));
        this.buildMessagePanel(panel, SWTUtil.stringFor("preference.ruleedit.label.message"));
        return panel;
    }

    private void validateRuleParams() {
        this.validate();
        boolean urlOK = StringUtils.isBlank((CharSequence)this.externalURLField.getText()) || this.hasValidURL();
        this.adjustBrowseButton(urlOK);
    }

    private void buildExternalUrlPanel(Composite parent, String urlLabel) {
        GridData gridData = new GridData(32);
        this.extURLLabel = new Label(parent, 0);
        this.extURLLabel.setText(urlLabel);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.extURLLabel.setLayoutData((Object)gridData);
        this.externalURLField = new Text(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.externalURLField.setLayoutData((Object)gridData);
        this.browseButton = this.buildExternalInfoUrlButton(parent);
        gridData = new GridData(64);
        gridData.horizontalSpan = 1;
        this.browseButton.setLayoutData((Object)gridData);
        this.externalURLField.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                DescriptionPanelManager.this.handleExternalURLChange();
            }
        });
        this.externalURLField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DescriptionPanelManager.this.validateRuleParams();
            }
        });
    }

    private void buildMessagePanel(Composite parent, String messageLbl) {
        GridData gridData = new GridData(32);
        this.messageLabel = new Label(parent, 0);
        this.messageLabel.setText(messageLbl);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = false;
        this.messageLabel.setLayoutData((Object)gridData);
        this.messageField = new Text(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.messageField.setLayoutData((Object)gridData);
        this.messageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DescriptionPanelManager.this.handleMessageChange();
                DescriptionPanelManager.this.validateRuleParams();
            }
        });
    }

    private void handleExternalURLChange() {
        String newURL = this.asCleanString(this.externalURLField.getText());
        Rule rule = this.soleRule();
        if (!StringUtils.equals((CharSequence)StringUtils.stripToNull((String)this.asCleanString(rule.getExternalInfoUrl())), (CharSequence)StringUtils.stripToNull((String)newURL))) {
            rule.setExternalInfoUrl(newURL);
            this.valueChanged(null, newURL);
        }
        this.adjustBrowseButton(this.hasValidURL());
    }

    private void handleMessageChange() {
        String newMessage = this.asCleanString(this.messageField.getText());
        Rule rule = this.soleRule();
        if (!StringUtils.equals((CharSequence)StringUtils.stripToNull((String)this.asCleanString(rule.getMessage())), (CharSequence)StringUtils.stripToNull((String)newMessage))) {
            rule.setMessage(newMessage);
            this.updateUI();
        }
    }

    private Button buildExternalInfoUrlButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(SWTUtil.stringFor("preference.ruleedit.button.open_external_info_url"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String url = DescriptionPanelManager.this.externalURLField.getText();
                if (url.length() > 0) {
                    try {
                        IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                        browser.openURL(new URL(url));
                    }
                    catch (MalformedURLException | PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return button;
    }

    @Override
    protected void adapt() {
        Rule soleRule = this.soleRule();
        if (soleRule == null) {
            this.shutdown(this.descriptionBox);
            this.shutdown(this.externalURLField);
            this.shutdown(this.messageField);
        } else {
            this.show(this.descriptionBox, this.asCleanString(soleRule.getDescription()));
            this.show(this.externalURLField, this.asCleanString(soleRule.getExternalInfoUrl()));
            this.show(this.messageField, this.asCleanString(soleRule.getMessage()));
        }
        boolean isValid = this.hasValidURL();
        this.adjustBrowseButton(isValid);
    }

    public static boolean isValidURL(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        String urlUC = url.toUpperCase(Locale.ROOT);
        if (!urlUC.startsWith("HTTP")) {
            return false;
        }
        int i = 0;
        while (i < url.length()) {
            if (Character.isWhitespace(url.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasValidURL() {
        String url = this.externalURLField.getText().trim();
        return StringUtils.isBlank((CharSequence)url) || DescriptionPanelManager.isValidURL(url);
    }

    private void adjustBrowseButton(boolean hasValidURL) {
        this.browseButton.setEnabled(hasValidURL);
        this.externalURLField.setForeground(hasValidURL ? textColour : errorColour);
    }

    @Override
    protected List<String> fieldErrors() {
        ArrayList<String> errors = new ArrayList<String>(3);
        if (StringUtils.isBlank((CharSequence)this.descriptionBox.getText().trim())) {
            errors.add("Missing description");
        }
        if (StringUtils.isBlank((CharSequence)this.messageField.getText().trim())) {
            errors.add("Missing message");
        }
        if (!this.hasValidURL()) {
            errors.add("Invalid external URL");
        }
        return errors;
    }
}

