/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.PageBuilder;
import net.sourceforge.pmd.eclipse.ui.StringArranger;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.Configuration;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SummaryPanelManager
extends AbstractRulePanelManager {
    private StyledText viewField;
    private PageBuilder pb = new PageBuilder(3, 9, UISettings.CODE_FONT_BUILDER);
    private StringArranger arranger = new StringArranger("   ");

    public SummaryPanelManager(String theId, String theTitle, EditorUsageMode theMode, ValueChangeListener theListener) {
        super(theId, theTitle, theMode, theListener);
    }

    public static String asLabel(Class<?> type) {
        return type.isArray() ? String.valueOf(type.getComponentType().getSimpleName()) + "[]" : type.getSimpleName();
    }

    public static int longestNameIn(Map<PropertyDescriptor<?>, Object> valuesByDescriptor) {
        int longest = 0;
        for (Map.Entry<PropertyDescriptor<?>, Object> entry : valuesByDescriptor.entrySet()) {
            longest = Math.max(longest, entry.getKey().name().length());
        }
        return longest;
    }

    public static String pad(String text, int length, char padChar) {
        int delta = length - text.length();
        if (delta == 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(text);
        int i = 0;
        while (i < delta) {
            sb.append(padChar);
            ++i;
        }
        return sb.toString();
    }

    @Override
    protected void adapt() {
        Rule rule = this.soleRule();
        this.showFor(rule);
    }

    public void showFor(Rule rule) {
        List examples;
        Map<PropertyDescriptor<?>, Object> valuesByDescriptor;
        this.pb.clear();
        if (rule == null) {
            this.pb.showOn(this.viewField);
            return;
        }
        this.pb.addHeading("preference.summary.label.name");
        this.pb.addText(rule.getName());
        this.pb.addHeading("preference.summary.label.description");
        this.pb.addRawText(this.arranger.format(rule.getDescription()).toString());
        String url = rule.getExternalInfoUrl();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            this.pb.addRawText(this.arranger.withIndent("More information can be found "));
            this.pb.addLink("here.\n", url);
        }
        if (!(valuesByDescriptor = Configuration.filteredPropertiesOf((PropertySource)rule)).isEmpty()) {
            this.pb.addHeading("preference.summary.label.parameters");
            int longest = SummaryPanelManager.longestNameIn(valuesByDescriptor);
            for (Map.Entry<PropertyDescriptor<?>, Object> entry : valuesByDescriptor.entrySet()) {
                PropertyDescriptor<?> desc = entry.getKey();
                this.pb.addText(String.valueOf(SummaryPanelManager.pad(desc.name(), longest, ' ')) + '\t' + SummaryPanelManager.asLabel(entry.getValue().getClass()));
            }
        }
        if ((examples = rule.getExamples()).isEmpty()) {
            this.pb.showOn(this.viewField);
            return;
        }
        this.pb.setLanguage(rule.getLanguage());
        this.pb.addHeading("preference.summary.label.example");
        this.pb.addText("");
        for (String example : rule.getExamples()) {
            this.pb.addCode(example.trim());
            this.pb.addText("");
        }
        this.pb.showOn(this.viewField);
        if (this.pb.hasLinks()) {
            this.pb.addLinkHandler(this.viewField);
        }
        this.viewField.setEditable(false);
    }

    public void setVisible(boolean flag) {
        this.viewField.setVisible(flag);
    }

    @Override
    protected boolean canManageMultipleRules() {
        return false;
    }

    @Override
    protected boolean canWorkWith(Rule rule) {
        return true;
    }

    @Override
    protected void clearControls() {
    }

    @Override
    public Control setupOn(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new FillLayout());
        this.viewField = new StyledText(panel, 2816);
        this.viewField.setWordWrap(true);
        this.viewField.setTabs(20);
        return panel;
    }

    @Override
    public void showControls(boolean flag) {
        this.viewField.setVisible(flag);
    }
}

