/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ImplementationType;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.AbstractRulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class XPathPanelManager
extends AbstractRulePanelManager {
    private StyledText xpathField;
    private List<String> unknownVariableNames;
    public static final String ID = "xpath";

    public XPathPanelManager(String theTitle, EditorUsageMode theMode, ValueChangeListener theListener) {
        super(ID, theTitle, theMode, theListener);
    }

    @Override
    protected boolean canManageMultipleRules() {
        return false;
    }

    @Override
    protected boolean canWorkWith(Rule rule) {
        return RuleSelection.implementationType(rule) == ImplementationType.XPath;
    }

    @Override
    protected List<String> fieldErrors() {
        ArrayList<String> errors = new ArrayList<String>(2);
        if (StringUtils.isBlank((CharSequence)this.xpathField.getText())) {
            errors.add("Missing XPATH code");
        }
        if (this.unknownVariableNames == null || this.unknownVariableNames.isEmpty()) {
            return errors;
        }
        errors.add("Unknown variables: " + this.unknownVariableNames);
        return errors;
    }

    @Override
    protected void clearControls() {
        this.xpathField.setText("");
    }

    @Override
    public void showControls(boolean flag) {
        this.xpathField.setVisible(flag);
    }

    private PropertyDescriptor<String> getXPathDescriptor(PropertySource propertySource) {
        return propertySource.getPropertyDescriptor(ID);
    }

    @Override
    protected void updateOverridenFields() {
        Rule rule = this.soleRule();
        if (rule instanceof RuleReference) {
            RuleReference ruleReference = (RuleReference)rule;
            this.xpathField.setBackground((Color)(ruleReference.isPropertyOverridden(this.getXPathDescriptor((PropertySource)ruleReference)) ? overridenColour : null));
        }
    }

    @Override
    public Control setupOn(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        this.xpathField = this.newCodeField(panel);
        SyntaxManager.adapt(this.xpathField, ID, null);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.xpathField.setLayoutData((Object)gridData);
        this.xpathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!XPathPanelManager.this.isActive()) {
                    return;
                }
                Rule soleRule = XPathPanelManager.this.soleRule();
                if (soleRule == null) {
                    return;
                }
                String newValue = XPathPanelManager.this.xpathField.getText().trim();
                PropertyDescriptor xpathDescriptor = XPathPanelManager.this.getXPathDescriptor((PropertySource)soleRule);
                String existingValue = ((String)soleRule.getProperty(xpathDescriptor)).trim();
                if (StringUtils.equals((CharSequence)StringUtils.stripToNull((String)existingValue), (CharSequence)StringUtils.stripToNull((String)newValue))) {
                    return;
                }
                XPathPanelManager.this.validate();
                soleRule.setProperty(xpathDescriptor, (Object)newValue);
                XPathPanelManager.this.valueChanged(xpathDescriptor, newValue);
            }
        });
        return panel;
    }

    @Override
    public void adapt() {
        Rule soleRule = this.soleRule();
        if (soleRule == null) {
            this.shutdown(this.xpathField);
        } else {
            PropertyDescriptor<String> xpathDescriptor = this.getXPathDescriptor((PropertySource)soleRule);
            this.show(this.xpathField, ((String)soleRule.getProperty(xpathDescriptor)).trim());
        }
        this.validate();
    }
}

