/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.priority;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.ShapeDescriptor;
import net.sourceforge.pmd.eclipse.ui.ShapePainter;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorIcon;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractPMDAction;
import net.sourceforge.pmd.lang.rule.RulePriority;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;

public class PriorityDescriptor
implements Cloneable {
    public final RulePriority priority;
    public String label;
    public String description;
    public String filterText;
    public String iconId;
    public ShapeDescriptor shape;
    private static final RGB PROTO_TRANSPARENT_COLOR = new RGB(1, 1, 1);
    private static final char DELIMITER = '_';
    private ConcurrentMap<Integer, Image> cachedImages = new ConcurrentHashMap<Integer, Image>(3);
    private static final int ANNOTATION_IMAGE_DIMENSION = 9;

    public PriorityDescriptor(RulePriority thePriority, String theLabelKey, String theFilterTextKey, String theIconId, Shape theShape, RGB theColor, int theSize) {
        this(thePriority, theLabelKey, theFilterTextKey, theIconId, new ShapeDescriptor(theShape, theColor, theSize));
    }

    public PriorityDescriptor(RulePriority thePriority, String theLabelKey, String theFilterTextKey, String theIconId, ShapeDescriptor theShape) {
        this.priority = thePriority;
        this.label = AbstractPMDAction.getString(theLabelKey);
        this.description = "--";
        this.filterText = AbstractPMDAction.getString(theFilterTextKey);
        this.iconId = null;
        if (theIconId != null && !theIconId.isEmpty() && !"null".equals(theIconId)) {
            this.iconId = theIconId;
        }
        this.shape = theShape;
    }

    public static PriorityDescriptor from(String text) {
        String[] values = text.split(Character.toString('_'));
        if (values.length != 7) {
            return null;
        }
        RGB rgb = PriorityDescriptor.rgbFrom(values[5]);
        if (rgb == null) {
            return null;
        }
        return new PriorityDescriptor(RulePriority.valueOf((int)Integer.parseInt(values[0])), values[1], values[2], values[3], PriorityDescriptor.shapeFrom(values[4]), rgb, Integer.parseInt(values[6]));
    }

    private static Shape shapeFrom(String id) {
        int num = Integer.parseInt(id);
        for (Shape shape : EnumSet.allOf(Shape.class)) {
            if (shape.id != num) continue;
            return shape;
        }
        return null;
    }

    private static RGB rgbFrom(String desc) {
        String[] clrs = desc.split(",");
        if (clrs.length != 3) {
            return null;
        }
        return new RGB(Integer.parseInt(clrs[0]), Integer.parseInt(clrs[1]), Integer.parseInt(clrs[2]));
    }

    private static void rgbOn(StringBuilder sb, RGB rgb) {
        sb.append(rgb.red).append(',');
        sb.append(rgb.green).append(',');
        sb.append(rgb.blue);
    }

    public String storeString() {
        StringBuilder sb = new StringBuilder();
        this.storeOn(sb);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        PriorityDescriptor otherOne = (PriorityDescriptor)other;
        return this.priority.equals((Object)otherOne.priority) && StringUtils.equals((CharSequence)this.label, (CharSequence)otherOne.label) && this.shape.equals(otherOne.shape) && StringUtils.equals((CharSequence)this.description, (CharSequence)otherOne.description) && StringUtils.equals((CharSequence)this.filterText, (CharSequence)otherOne.filterText) && StringUtils.equals((CharSequence)this.iconId, (CharSequence)otherOne.iconId);
    }

    public int hashCode() {
        return this.priority.hashCode() ^ this.shape.hashCode() ^ String.valueOf(this.label).hashCode() ^ String.valueOf(this.description).hashCode() ^ String.valueOf(this.iconId).hashCode();
    }

    public void storeOn(StringBuilder sb) {
        sb.append(this.priority.getPriority()).append('_');
        sb.append(this.label).append('_');
        sb.append(this.filterText).append('_');
        if (this.iconId != null) {
            sb.append(this.iconId);
        }
        sb.append('_');
        sb.append(this.shape.shape.id).append('_');
        PriorityDescriptor.rgbOn(sb, this.shape.rgbColor);
        sb.append('_');
        sb.append(this.shape.size).append('_');
    }

    public PriorityDescriptor clone() {
        try {
            PriorityDescriptor copy = (PriorityDescriptor)super.clone();
            copy.label = this.label;
            copy.description = this.description;
            copy.filterText = this.filterText;
            copy.iconId = this.iconId;
            copy.shape = this.shape.clone();
            copy.cachedImages = new ConcurrentHashMap<Integer, Image>(3);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PriorityDescriptor: ");
        sb.append(this.priority).append(", ");
        sb.append(this.label).append(", ");
        sb.append(this.description).append(", ");
        sb.append(this.filterText).append(", ");
        sb.append(this.iconId).append(", ");
        sb.append(this.shape);
        return sb.toString();
    }

    public Image getAnnotationImage() {
        return this.getImage(9);
    }

    public ImageDescriptor getAnnotationImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)this.getAnnotationImage());
    }

    private Image createImage(int size) {
        if (this.iconId == null || this.iconId.isEmpty() || "null".equals(this.iconId)) {
            return ShapePainter.newDrawnImage(null, size, size, this.shape.shape, PROTO_TRANSPARENT_COLOR, this.shape.rgbColor);
        }
        Image srcImage = PriorityDescriptorIcon.getById(this.iconId).getImage();
        ImageData imageData = srcImage.getImageData().scaledTo(size, size);
        return new Image(srcImage.getDevice(), imageData);
    }

    public Image getImage(int size) {
        Image cached = (Image)this.cachedImages.get(size);
        if (cached == null) {
            Image newImage = this.createImage(size);
            cached = this.cachedImages.putIfAbsent(size, newImage);
            if (cached == null) {
                cached = newImage;
            } else {
                newImage.dispose();
            }
        }
        return cached;
    }

    public Image createImage() {
        return this.createImage(this.shape.size);
    }

    public void dispose() {
        HashSet copy = new HashSet(this.cachedImages.values());
        this.cachedImages.clear();
        for (Image image : copy) {
            image.dispose();
        }
    }
}

