/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.priority;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import net.sourceforge.pmd.lang.rule.RulePriority;

public final class PriorityDescriptorCache {
    private final ConcurrentMap<RulePriority, PriorityDescriptor> uiDescriptorsByPriority = new ConcurrentHashMap<RulePriority, PriorityDescriptor>(RulePriority.values().length);
    public static final PriorityDescriptorCache INSTANCE = new PriorityDescriptorCache();

    private PriorityDescriptorCache() {
        this.loadFromPreferences();
    }

    private IPreferencesManager preferencesManager() {
        return PMDPlugin.getDefault().getPreferencesManager();
    }

    public void loadFromPreferences() {
        IPreferences preferences = this.preferencesManager().loadPreferences();
        RulePriority[] rulePriorityArray = UISettings.currentPriorities(true);
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            RulePriority rp = rulePriorityArray[n2];
            this.uiDescriptorsByPriority.put(rp, preferences.getPriorityDescriptor(rp).clone());
            ++n2;
        }
    }

    public void storeInPreferences() {
        IPreferencesManager mgr = this.preferencesManager();
        IPreferences prefs = mgr.loadPreferences();
        for (Map.Entry entry : this.uiDescriptorsByPriority.entrySet()) {
            prefs.setPriorityDescriptor((RulePriority)entry.getKey(), ((PriorityDescriptor)entry.getValue()).clone());
        }
        prefs.sync();
        this.dispose();
    }

    public PriorityDescriptor descriptorFor(RulePriority priority) {
        return (PriorityDescriptor)this.uiDescriptorsByPriority.get(priority);
    }

    public boolean hasChanges() {
        IPreferences currentPreferences = this.preferencesManager().loadPreferences();
        RulePriority[] rulePriorityArray = UISettings.currentPriorities(true);
        int n = rulePriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityDescriptor currentOne;
            RulePriority rp = rulePriorityArray[n2];
            PriorityDescriptor newOne = (PriorityDescriptor)this.uiDescriptorsByPriority.get(rp);
            if (!newOne.equals(currentOne = currentPreferences.getPriorityDescriptor(rp))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void dispose() {
        for (PriorityDescriptor pd : this.uiDescriptorsByPriority.values()) {
            pd.dispose();
        }
    }
}

