/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.priority;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.swt.graphics.Image;

public final class PriorityDescriptorIcon {
    private final String iconId;
    private final String imagePath;
    public static final PriorityDescriptorIcon[] ICONS = new PriorityDescriptorIcon[]{new PriorityDescriptorIcon("icon-prio-1", "icons/prio_1.gif"), new PriorityDescriptorIcon("icon-prio-2", "icons/prio_2.gif"), new PriorityDescriptorIcon("icon-prio-3", "icons/prio_3.gif"), new PriorityDescriptorIcon("icon-prio-4", "icons/prio_4.gif"), new PriorityDescriptorIcon("icon-prio-5", "icons/prio_5.gif"), new PriorityDescriptorIcon("icon-pmd", "icons/pmd-icon-16.gif"), new PriorityDescriptorIcon("icon-error", "icons/error.gif"), new PriorityDescriptorIcon("icon-warn", "icons/warn.gif"), new PriorityDescriptorIcon("icon-info", "icons/info.gif")};
    private static final Map<String, PriorityDescriptorIcon> ICONS_BY_ID = new HashMap<String, PriorityDescriptorIcon>(ICONS.length);

    static {
        PriorityDescriptorIcon[] priorityDescriptorIconArray = ICONS;
        int n = ICONS.length;
        int n2 = 0;
        while (n2 < n) {
            PriorityDescriptorIcon icon = priorityDescriptorIconArray[n2];
            ICONS_BY_ID.put(icon.getIconId(), icon);
            ++n2;
        }
    }

    private PriorityDescriptorIcon(String iconId, String imagePath) {
        this.iconId = iconId;
        this.imagePath = imagePath;
    }

    public String getIconId() {
        return this.iconId;
    }

    public Image getImage() {
        return PMDPlugin.getDefault().getImage(this.iconId, this.imagePath);
    }

    public static PriorityDescriptorIcon getById(String iconId) {
        return ICONS_BY_ID.get(iconId);
    }
}

