/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.properties;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractProjectCommand;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.lang.rule.RuleSet;
import org.eclipse.ui.IWorkingSet;

public class UpdateProjectPropertiesCmd
extends AbstractProjectCommand {
    private boolean pmdEnabled;
    private IWorkingSet projectWorkingSet;
    private List<RuleSet> projectRuleSets;
    private boolean ruleSetStoredInProject;
    private String ruleSetFile;
    private boolean needRebuild;
    private boolean ruleSetFileExists;
    private boolean includeDerivedFiles;
    private boolean fullBuildEnabled = true;
    private boolean violationsAsErrors = true;

    public UpdateProjectPropertiesCmd() {
        super("UpdateProjectProperties", "Update a project PMD specific properties.");
        this.setReadOnly(false);
        this.setOutputProperties(true);
        this.setTerminated(false);
    }

    @Override
    public void execute() {
        try {
            try {
                IProjectProperties properties = this.projectProperties();
                properties.setPmdEnabled(this.pmdEnabled);
                properties.setProjectRuleSetList(this.projectRuleSets);
                properties.setProjectWorkingSet(this.projectWorkingSet);
                properties.setRuleSetFile(this.ruleSetFile);
                properties.setRuleSetStoredInProject(this.ruleSetStoredInProject);
                properties.setIncludeDerivedFiles(this.includeDerivedFiles);
                properties.setFullBuildEnabled(this.fullBuildEnabled);
                properties.setViolationsAsErrors(this.violationsAsErrors);
                properties.sync();
                this.needRebuild = properties.isNeedRebuild();
                this.ruleSetFileExists = !properties.isRuleSetFileExist();
            }
            catch (PropertiesException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        finally {
            this.setTerminated(true);
        }
    }

    public void setPmdEnabled(boolean pmdEnabled) {
        this.pmdEnabled = pmdEnabled;
    }

    public void setProjectRuleSet(RuleSet projectRuleSet) {
        this.projectRuleSets = Collections.singletonList(projectRuleSet);
    }

    public void setProjectRuleSetList(List<RuleSet> projectRuleSets) {
        this.projectRuleSets = projectRuleSets;
    }

    public void setProjectWorkingSet(IWorkingSet projectWorkingSet) {
        this.projectWorkingSet = projectWorkingSet;
    }

    public void setRuleSetStoredInProject(boolean ruleSetStoredInProject) {
        this.ruleSetStoredInProject = ruleSetStoredInProject;
    }

    public void setRuleSetFile(String ruleSetFile) {
        this.ruleSetFile = ruleSetFile;
    }

    public void setIncludeDerivedFiles(boolean includeDerivedFiles) {
        this.includeDerivedFiles = includeDerivedFiles;
    }

    public void setFullBuildEnabled(boolean fullBuildEnabled) {
        this.fullBuildEnabled = fullBuildEnabled;
    }

    public void setViolationsAsErrors(boolean violationsAsErrors) {
        this.violationsAsErrors = violationsAsErrors;
    }

    public boolean isNeedRebuild() {
        return this.needRebuild && this.fullBuildEnabled;
    }

    public boolean isRuleSetFileExists() {
        return this.ruleSetFileExists;
    }

    @Override
    public void reset() {
        this.setProject(null);
        this.setPmdEnabled(false);
        this.setProjectRuleSetList(null);
        this.setRuleSetStoredInProject(false);
        this.setRuleSetFile(null);
        this.setIncludeDerivedFiles(false);
        this.setFullBuildEnabled(true);
        this.setViolationsAsErrors(true);
        this.setTerminated(false);
    }

    @Override
    public boolean isReadyToExecute() {
        return super.isReadyToExecute() && this.projectRuleSets != null;
    }
}

