/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.reports;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;

public final class ReportManager {
    private final Renderer[] allRenderers = this.availableRenderers2();
    public static final ReportManager INSTANCE = new ReportManager();
    public static final String DEFAULT_REPORT_PROPERTY_FILENAME = "reportProperties.xml";

    private ReportManager() {
    }

    public Renderer[] allRenderers() {
        return this.allRenderers;
    }

    public Renderer[] availableRenderers2() {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        for (String reportName : RendererFactory.supportedRenderers()) {
            renderers.add(RendererFactory.createRenderer((String)reportName, (Properties)new Properties()));
        }
        return renderers.toArray(new Renderer[0]);
    }

    public List<Renderer> activeRenderers() {
        ArrayList<Renderer> actives = new ArrayList<Renderer>();
        IPreferences prefs = PMDPlugin.getDefault().loadPreferences();
        Renderer[] rendererArray = this.allRenderers;
        int n = this.allRenderers.length;
        int n2 = 0;
        while (n2 < n) {
            Renderer renderer = rendererArray[n2];
            if (prefs.isActiveRenderer(renderer.getName())) {
                actives.add(renderer);
            }
            ++n2;
        }
        return actives;
    }

    public static String asString(Map<PropertyDescriptor<?>, Object> propertyDefinitions) {
        if (propertyDefinitions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<PropertyDescriptor<?>, Object> entry : propertyDefinitions.entrySet()) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey().name()).append(": ").append(String.valueOf(entry.getValue()));
        }
        return sb.toString();
    }

    private static String keyOf(Renderer renderer, PropertyDescriptor<?> desc) {
        return String.valueOf(renderer.getName()) + "__" + desc.name();
    }

    public static void loadReportProperties() {
        ReportManager.loadReportProperties(DEFAULT_REPORT_PROPERTY_FILENAME);
    }

    public static void saveReportProperties() {
        ReportManager.saveReportProperties(DEFAULT_REPORT_PROPERTY_FILENAME);
    }

    private static boolean loadReportProperties(String propertyFilename) {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream in = Files.newInputStream(new File(propertyFilename).toPath(), new OpenOption[0]);){
                props.loadFromXML(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return false;
        }
        Renderer[] rendererArray = INSTANCE.allRenderers();
        int n = rendererArray.length;
        int n2 = 0;
        while (n2 < n) {
            Renderer renderer = rendererArray[n2];
            for (PropertyDescriptor pDesc : renderer.getPropertyDescriptors()) {
                String key = ReportManager.keyOf(renderer, pDesc);
                if (!props.containsKey(key)) continue;
                Object value = pDesc.serializer().fromString(props.getProperty(key));
                renderer.setProperty(pDesc, value);
            }
            ++n2;
        }
        return true;
    }

    private static void saveReportProperties(String propertyFilename) {
        Object renderer;
        Properties props = new Properties();
        Renderer[] rendererArray = INSTANCE.allRenderers();
        int n = rendererArray.length;
        int n2 = 0;
        while (n2 < n) {
            renderer = rendererArray[n2];
            Map valuesByProp = renderer.getPropertiesByPropertyDescriptor();
            for (Map.Entry entry : valuesByProp.entrySet()) {
                PropertyDescriptor desc = (PropertyDescriptor)entry.getKey();
                props.put(ReportManager.keyOf((Renderer)renderer, desc), desc.serializer().toString(entry.getValue()));
            }
            ++n2;
        }
        try {
            renderer = null;
            Object var3_6 = null;
            try (OutputStream out = Files.newOutputStream(new File(propertyFilename).toPath(), new OpenOption[0]);){
                props.storeToXML(out, "asdf");
            }
            catch (Throwable throwable) {
                if (renderer == null) {
                    renderer = throwable;
                } else if (renderer != throwable) {
                    ((Throwable)renderer).addSuppressed(throwable);
                }
                throw renderer;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

