/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.reports;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.BasicTableLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.AbstractStructuredContentProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.br.AbstractPMDPreferencePage;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicTableManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.FormArranger;
import net.sourceforge.pmd.eclipse.ui.reports.ReportColumnUI;
import net.sourceforge.pmd.eclipse.ui.reports.ReportManager;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.renderers.Renderer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ReportPreferencesPage
extends AbstractPMDPreferencePage
implements ValueChangeListener,
SizeChangeListener {
    private TableViewer tableViewer;
    private FormArranger formArranger;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        ReportManager.loadReportProperties();
        Composite reportGroup = this.buildReportGroup(composite);
        Composite propertyGroup = this.buildPropertyGroup(composite);
        propertyGroup.setLayoutData((Object)new GridData(1808));
        reportGroup.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite buildPropertyGroup(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText("Properties");
        group.setLayout((Layout)new GridLayout(1, false));
        this.formArranger = new FormArranger((Composite)group, this, this);
        return group;
    }

    private Composite buildReportGroup(Composite parent) {
        TableColumn[] columns;
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        AbstractStructuredContentProvider contentProvider = new AbstractStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Renderer[])inputElement;
            }
        };
        BasicTableLabelProvider labelProvider = new BasicTableLabelProvider(ReportColumnUI.VISIBLE_COLUMNS);
        BasicTableManager reportTableMgr = new BasicTableManager("renderers", null, ReportColumnUI.VISIBLE_COLUMNS);
        this.tableViewer = reportTableMgr.buildTableViewer(group, 68386);
        reportTableMgr.setupColumns(ReportColumnUI.VISIBLE_COLUMNS);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 2, true, true, 2, 1));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        table.setHeaderVisible(true);
        this.tableViewer.setInput((Object)ReportManager.INSTANCE.allRenderers());
        this.selectCheckedRenderers();
        TableColumn[] tableColumnArray = columns = table.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        Composite editorPanel = new Composite(group, 0);
        editorPanel.setLayoutData((Object)new GridData(4, 2, true, true));
        editorPanel.setLayout((Layout)new GridLayout(4, false));
        Label nameLabel = new Label(editorPanel, 0);
        nameLabel.setLayoutData((Object)new GridData());
        nameLabel.setText("Name:");
        final Label rendererName = new Label(editorPanel, 2048);
        rendererName.setLayoutData((Object)new GridData(4, 2, true, true));
        final Button suppressed = new Button(editorPanel, 32);
        suppressed.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        suppressed.setText("Show suppressed violations");
        Label descLabel = new Label(editorPanel, 0);
        descLabel.setLayoutData((Object)new GridData());
        descLabel.setText("Description:");
        final Label descValue = new Label(editorPanel, 2048);
        descValue.setLayoutData((Object)new GridData(4, 2, true, true, 3, 1));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                List items = selection.toList();
                ReportPreferencesPage.selectedRenderers(items, rendererName, descValue, suppressed);
                if (items.size() == 1) {
                    ReportPreferencesPage.this.formArranger.arrangeFor((PropertySource)((Renderer)items.get(0)));
                } else {
                    ReportPreferencesPage.this.formArranger.clearChildren();
                }
            }
        });
        this.tableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    ReportPreferencesPage.this.checked();
                }
            }
        });
        suppressed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }
        });
        rendererName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ReportPreferencesPage.this.setName(rendererName.getText());
            }
        });
        return group;
    }

    private void selectCheckedRenderers() {
        Set<String> activeNames = this.preferences.activeReportRenderers();
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Renderer ren = (Renderer)item.getData();
            item.setChecked(activeNames.contains(ren.getName()));
            ++n2;
        }
    }

    private Set<String> currentCheckedRenderers() {
        HashSet<String> names = new HashSet<String>();
        for (Object renderer : ReportPreferencesPage.checkedItems(this.tableViewer.getTable())) {
            names.add(((Renderer)renderer).getName());
        }
        return names;
    }

    private static Set<Object> checkedItems(Table table) {
        HashSet<Object> checkedItems = new HashSet<Object>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getChecked()) {
                checkedItems.add(ti.getData());
            }
            ++n2;
        }
        return checkedItems;
    }

    private void checked() {
        boolean matches = this.currentCheckedRenderers().equals(this.preferences.activeReportRenderers());
        this.setModified(!matches);
    }

    private void setName(String newName) {
        if (StringUtils.isBlank((CharSequence)newName)) {
            return;
        }
        this.selectedRenderers();
        this.tableViewer.refresh();
    }

    private Renderer[] selectedRenderers() {
        Object[] items = ((IStructuredSelection)this.tableViewer.getSelection()).toArray();
        Renderer[] renderers = new Renderer[items.length];
        int i = 0;
        while (i < renderers.length) {
            renderers[i] = (Renderer)items[i];
            ++i;
        }
        return renderers;
    }

    private static void selectedRenderers(List<Renderer> items, Label nameField, Label descField, Button suppressed) {
        if (items.size() != 1) {
            nameField.setText("");
            return;
        }
        Renderer renderer = items.get(0);
        nameField.setText(renderer.getName());
        descField.setText(renderer.getDescription());
        suppressed.setSelection(renderer.isShowSuppressedViolations());
    }

    protected void performDefaults() {
    }

    public boolean performCancel() {
        this.selectCheckedRenderers();
        return true;
    }

    @Override
    public boolean performOk() {
        ReportManager.saveReportProperties();
        this.preferences.activeReportRenderers(this.currentCheckedRenderers());
        this.preferences.sync();
        PMDPlugin.getDefault().applyLogPreferences(this.preferences);
        return true;
    }

    @Override
    protected String descriptionId() {
        return "???";
    }

    @Override
    public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
    }

    @Override
    public void addedRows(int newRowCount) {
    }

    @Override
    public void changed(RuleSelection rule, PropertyDescriptor<?> desc, Object newValue) {
    }
}

