/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViewMemento;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public abstract class AbstractPMDPagebookView
extends PageBookView {
    protected ViewMemento memento;

    protected AbstractPMDPagebookView() {
    }

    public static FileRecord tryForFileRecordFrom(IWorkbenchPart part) {
        IEditorInput input;
        if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            return new FileRecord((IResource)file);
        }
        return null;
    }

    protected abstract String pageMessageId();

    protected abstract String mementoFileId();

    protected boolean hasMemento() {
        return this.memento != null;
    }

    protected IWorkbenchPage getSitePage() {
        return this.getSite().getPage();
    }

    protected FileRecord getFileRecordFromWorkbenchPart(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                return new FileRecord((IResource)file);
            }
        } else {
            IEditorPart editorPart = this.getSite().getPage().getActiveEditor();
            if (editorPart != null) {
                return this.getFileRecordFromWorkbenchPart((IWorkbenchPart)editorPart);
            }
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.memento = new ViewMemento(this.mementoFileId());
    }

    protected void save(String mementoId, List<Integer> integerList) {
        this.memento.putList(mementoId, integerList);
    }

    protected List<Integer> getIntegerList(String mementoId) {
        return this.memento == null ? Collections.emptyList() : this.memento.getIntegerList(mementoId);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.partActivated(part);
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        return page == null ? null : page.getActiveEditor();
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(AbstractPMDPagebookView.getString(this.pageMessageId()));
        return page;
    }

    protected static String getString(String textId) {
        return PMDPlugin.getDefault().getStringTable().getString(textId);
    }

    public void dispose() {
        this.memento.save();
        super.dispose();
    }
}

