/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.ast.ASTUtil;
import net.sourceforge.pmd.eclipse.ui.views.ast.XPathEvaluator;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public abstract class AbstractStructureInspectorPage
extends Page
implements IPropertyChangeListener,
ISelectionChangedListener {
    private Combo methodSelector;
    private FileRecord resourceRecord;
    protected Node classNode;
    private List<ASTMethodDeclaration> pmdMethodList;
    protected ITextEditor textEditor;

    protected AbstractStructureInspectorPage(IWorkbenchPart part, FileRecord record) {
        this.resourceRecord = record;
        if (part instanceof ITextEditor) {
            this.textEditor = (ITextEditor)part;
            String source = this.getDocument().get();
            this.classNode = XPathEvaluator.INSTANCE.getCompilationUnit(source);
        }
    }

    public void refresh(IResource resource) {
        if (resource.getType() == 1) {
            this.resourceRecord = new FileRecord(resource);
            String source = this.getDocument().get();
            this.classNode = XPathEvaluator.INSTANCE.getCompilationUnit(source);
        }
    }

    protected void refreshMethodSelector() {
        int index = this.methodSelector.getSelectionIndex();
        this.refreshPMDMethods();
        this.showMethod(index);
        this.methodSelector.select(index);
    }

    protected void highlight(int beginLine, int beginColumn, int endLine, int endColumn) {
        if (this.textEditor == null) {
            return;
        }
        try {
            int offset = this.getDocument().getLineOffset(beginLine) + beginColumn;
            int length = this.getDocument().getLineOffset(endLine) + endColumn - offset;
            this.highlight(offset, length);
        }
        catch (BadLocationException ble) {
            AbstractStructureInspectorPage.logError("message.error.runtime_exceptionException when selecting a section in the editor", ble);
        }
    }

    protected IResource getResource() {
        return this.resourceRecord.getResource();
    }

    protected void highlight(int offset, int length) {
        if (this.textEditor == null) {
            return;
        }
        this.textEditor.selectAndReveal(offset, length);
    }

    protected void highlightLine(int lineNumber) {
        if (this.textEditor == null) {
            return;
        }
        int offset = 0;
        int length = 0;
        try {
            offset = this.getDocument().getLineOffset(lineNumber);
            length = this.getDocument().getLineLength(lineNumber);
        }
        catch (BadLocationException ble) {
            AbstractStructureInspectorPage.logError("message.error.runtime_exceptionException when selecting a line in the editor", ble);
        }
        this.highlight(offset, length);
    }

    public void propertyChange(PropertyChangeEvent event) {
        System.out.println("property changed: " + event.getProperty());
    }

    public void dispose() {
        super.dispose();
        this.unregisterListeners();
    }

    private static ColorRegistry colorRegistry() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme currentTheme = themeManager.getCurrentTheme();
        return currentTheme.getColorRegistry();
    }

    protected void registerListeners() {
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        AbstractStructureInspectorPage.colorRegistry().addListener((IPropertyChangeListener)this);
    }

    protected void unregisterListeners() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        AbstractStructureInspectorPage.colorRegistry().removeListener((IPropertyChangeListener)this);
    }

    public void setFocus() {
        this.methodSelector.setFocus();
    }

    protected void showMethodToViolation(RuleViolation violation) {
        int beginLine = violation.getBeginLine();
        int i = 0;
        while (i < this.pmdMethodList.size()) {
            ASTMethodDeclaration pmdMethod = this.pmdMethodList.get(i);
            if (beginLine >= pmdMethod.getBeginLine() && beginLine <= pmdMethod.getEndLine()) {
                this.showMethod(pmdMethod);
                this.methodSelector.select(i);
                return;
            }
            ++i;
        }
    }

    protected RuleViolation selectedViolationFrom(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            return element instanceof RuleViolation ? (RuleViolation)element : null;
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.textEditor == null) {
            return;
        }
        RuleViolation violation = this.selectedViolationFrom(event);
        if (violation == null) {
            return;
        }
        String varName = (String)violation.getAdditionalInfo().get("variableName");
        if (StringUtils.isBlank((CharSequence)varName)) {
            return;
        }
        int beginLine = violation.getBeginLine();
        int endLine = violation.getEndLine();
        if (beginLine != 0 && endLine != 0) {
            try {
                int offset = this.getDocument().getLineOffset(violation.getBeginLine() - 1);
                int length = this.getDocument().getLineOffset(violation.getEndLine()) - offset;
                this.textEditor.selectAndReveal(offset, length);
            }
            catch (BadLocationException ble) {
                AbstractStructureInspectorPage.logError("message.error.runtime_exceptionException when selecting a line in the editor", ble);
            }
            this.showMethodToViolation(violation);
        }
    }

    protected void refreshPMDMethods() {
        this.methodSelector.removeAll();
        this.pmdMethodList = this.getPMDMethods();
        for (ASTMethodDeclaration pmdMethod : this.pmdMethodList) {
            this.methodSelector.add(ASTUtil.getMethodLabel(pmdMethod, false));
        }
    }

    public void showFirstMethod() {
        this.methodSelector.select(0);
        this.showMethod(0);
    }

    public FileRecord getFileRecord() {
        return this.resourceRecord;
    }

    protected void showMethod(int index) {
        if (index >= 0 && index < this.pmdMethodList.size()) {
            ASTMethodDeclaration method = this.pmdMethodList.get(index);
            this.showMethod(method);
        }
    }

    protected abstract void showMethod(ASTMethodDeclaration var1);

    protected static String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    protected void buildMethodSelector(Composite parent) {
        this.methodSelector = new Combo(parent, 2060);
        this.refreshPMDMethods();
        this.methodSelector.setText(AbstractStructureInspectorPage.getString("view.dataflow.choose_method"));
        this.methodSelector.setLayoutData((Object)new GridData(300, -1));
        this.methodSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (AbstractStructureInspectorPage.this.methodSelector.equals(e.widget)) {
                    AbstractStructureInspectorPage.this.showMethod(AbstractStructureInspectorPage.this.methodSelector.getSelectionIndex());
                }
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractStructureInspectorPage.this.methodPicked();
            }
        });
    }

    public void methodPicked() {
        int index = this.methodSelector.getSelectionIndex();
        this.methodSelector.setSelection(new Point(0, 0));
        this.showMethod(index);
    }

    private List<ASTMethodDeclaration> getPMDMethods() {
        ArrayList<ASTMethodDeclaration> methodList = new ArrayList<ASTMethodDeclaration>();
        methodList.addAll(this.classNode.descendants(ASTMethodDeclaration.class).toList());
        Collections.sort(methodList, ASTUtil.METHOD_COMPARATOR);
        return methodList;
    }

    protected void enableMethodSelector(boolean flag) {
        this.methodSelector.setEnabled(flag);
    }

    public IDocument getDocument() {
        return this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
    }

    public static void logError(String message, Throwable error) {
        PMDPlugin.getDefault().logError(message, error);
    }

    public static void logErrorByKey(String messageId, Throwable error) {
        PMDPlugin.getDefault().logError(AbstractStructureInspectorPage.getString(messageId), error);
    }
}

