/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.lang.rule.RulePriority;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public final class PriorityFilter
extends ViewerFilter {
    private static final PriorityFilter INSTANCE = new PriorityFilter();
    private static final String PREFERENCE_KEY = String.valueOf(PriorityFilter.class.getName()) + ".enabledPriorities";
    private final Set<RulePriority> enabledPriorities;
    private Set<PriorityFilterChangeListener> listeners = new CopyOnWriteArraySet<PriorityFilterChangeListener>();
    private final ScopedPreferenceStore editorsPreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.ui.editors");

    private PriorityFilter() {
        this.enabledPriorities = Collections.synchronizedSet(EnumSet.allOf(RulePriority.class));
    }

    public static PriorityFilter getInstance() {
        return INSTANCE;
    }

    public void initialize() {
        this.addPriorityFilterChangeListener(new PriorityFilterChangeListener(){

            @Override
            public void priorityEnabled(RulePriority priority) {
                PriorityFilter.this.saveToPreferenceStore();
                PriorityFilter.this.showMarkers(priority);
            }

            @Override
            public void priorityDisabled(RulePriority priority) {
                PriorityFilter.this.saveToPreferenceStore();
                PriorityFilter.this.hideMarkers(priority);
            }
        });
        this.loadFromPreferenceStore();
    }

    private void saveToPreferenceStore() {
        StringBuilder asString = new StringBuilder(50);
        for (RulePriority rulePriority : this.enabledPriorities) {
            asString.append(rulePriority.name()).append(',');
        }
        PMDPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_KEY, asString.toString());
    }

    private void loadFromPreferenceStore() {
        String priorities = PMDPlugin.getDefault().getPreferenceStore().getString(PREFERENCE_KEY);
        if (priorities != null && !priorities.isEmpty()) {
            this.enabledPriorities.clear();
            String[] stringArray = priorities.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String priority = stringArray[n2];
                this.enabledPriorities.add(RulePriority.valueOf((String)priority));
                ++n2;
            }
        }
    }

    private String getMarkerKeyVerticalRuler(RulePriority priority) {
        return "net.sourceforge.pmd.eclipse.plugin.annotation.prio" + priority.getPriority() + ".verticalruler";
    }

    private String getMarkerKeyOverviewRuler(RulePriority priority) {
        return "net.sourceforge.pmd.eclipse.plugin.annotation.prio" + priority.getPriority() + ".overviewruler";
    }

    private void showMarkers(RulePriority priority) {
        this.editorsPreferences.setValue(this.getMarkerKeyVerticalRuler(priority), true);
        this.editorsPreferences.setValue(this.getMarkerKeyOverviewRuler(priority), true);
    }

    private void hideMarkers(RulePriority priority) {
        this.editorsPreferences.setValue(this.getMarkerKeyVerticalRuler(priority), false);
        this.editorsPreferences.setValue(this.getMarkerKeyOverviewRuler(priority), false);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean select = false;
        if (element instanceof PackageRecord) {
            select = this.hasMarkersToShow((PackageRecord)element);
        } else if (element instanceof FileRecord) {
            select = this.hasMarkersToShow((FileRecord)element);
        } else if (element instanceof IMarker) {
            try {
                IMarker marker = (IMarker)element;
                Integer markerPrio = (Integer)marker.getAttribute("pmd_priority");
                select = this.isPriorityEnabled(markerPrio);
            }
            catch (CoreException ce) {
                PMDPlugin.getDefault().logError("message.error.core_exception" + ((Object)((Object)this)).toString(), ce);
            }
        } else if (element instanceof MarkerRecord) {
            MarkerRecord markerRec = (MarkerRecord)element;
            select = this.isPriorityEnabled(markerRec.getPriority());
        } else if (element instanceof FileToMarkerRecord) {
            select = true;
        }
        return select;
    }

    private boolean isPriorityEnabled(Integer markerPrio) {
        boolean isEnabled = false;
        if (markerPrio != null) {
            isEnabled = this.isPriorityEnabled(RulePriority.valueOf((int)markerPrio));
        }
        return isEnabled;
    }

    public boolean isPriorityEnabled(RulePriority priority) {
        return this.enabledPriorities.contains(priority);
    }

    private boolean hasMarkersToShow(AbstractPMDRecord record) {
        boolean hasMarkers = false;
        for (RulePriority priority : this.enabledPriorities) {
            IMarker[] markers = record.findMarkersByAttribute("pmd_priority", priority.getPriority());
            if (markers.length <= 0) continue;
            hasMarkers = true;
            break;
        }
        return hasMarkers;
    }

    public void enablePriority(RulePriority priority) {
        if (priority != null && this.enabledPriorities.add(priority)) {
            this.notifyPriorityEnabled(priority);
        }
    }

    public void disablePriority(RulePriority priority) {
        if (priority != null && this.enabledPriorities.remove(priority)) {
            this.notifyPriorityDisabled(priority);
        }
    }

    public void addPriorityFilterChangeListener(PriorityFilterChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePriorityFilterChangeListener(PriorityFilterChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyPriorityEnabled(RulePriority priority) {
        for (PriorityFilterChangeListener listener : this.listeners) {
            listener.priorityEnabled(priority);
        }
    }

    private void notifyPriorityDisabled(RulePriority priority) {
        for (PriorityFilterChangeListener listener : this.listeners) {
            listener.priorityDisabled(priority);
        }
    }

    public static interface PriorityFilterChangeListener {
        public void priorityEnabled(RulePriority var1);

        public void priorityDisabled(RulePriority var1);
    }
}

