/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ViewMemento {
    private final IPath path = PMDPlugin.getDefault().getStateLocation();
    private final File file;
    private XMLMemento memento;
    protected static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    protected static final String LIST_SEPARATOR = ":";
    protected static final String MEMENTO_PREFIX = "memento";
    protected static final String ATTRIBUTE_PREFIX = "attribute";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_VALUE = "value";

    public ViewMemento(String type) {
        this.file = new File(this.path.toString(), type);
        if (!this.file.exists() || !this.checkForXMLFile(this.file)) {
            this.createNewFile(this.file);
        }
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (BufferedReader reader = Files.newBufferedReader(this.file.toPath(), StandardCharsets.UTF_8);){
                this.memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (WorkbenchException wbe) {
            PMDPlugin.getDefault().logError("message.error.view_exception" + this.toString(), wbe);
        }
        catch (FileNotFoundException fnfe) {
            PMDPlugin.getDefault().logError("message.error.file_not_found" + this.path.toString() + "/" + type + " in " + this.toString(), fnfe);
        }
        catch (IOException e) {
            PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), e);
        }
        if (this.memento == null) {
            throw new IllegalStateException("Memento has not been built correctly. Check error log for details");
        }
    }

    protected final void createNewFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<memento/>");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
        }
    }

    protected final boolean checkForXMLFile(File file) {
        boolean isXmlFile = false;
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader contentReader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                while (contentReader.ready()) {
                    String line = contentReader.readLine();
                    if (line == null || line.length() == 0) continue;
                    isXmlFile = XML_PREFIX.equalsIgnoreCase(line);
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fnfe) {
            PMDPlugin.getDefault().logError("message.error.file_not_found" + file.toString() + " in " + this.toString(), fnfe);
        }
        catch (IOException ioe) {
            PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
        }
        return isXmlFile;
    }

    public void save() {
        if (this.memento != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedWriter writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                    this.memento.save((Writer)writer);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
            }
        }
    }

    private IMemento getAttribute(String name) {
        IMemento[] mementos = this.memento.getChildren(ATTRIBUTE_PREFIX);
        IMemento mem = null;
        IMemento[] iMementoArray = mementos;
        int n = mementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento2 = iMementoArray[n2];
            String attrName = memento2.getString(ATTR_NAME);
            if (name.equalsIgnoreCase(attrName)) {
                mem = memento2;
            }
            ++n2;
        }
        if (mem == null) {
            mem = this.memento.createChild(ATTRIBUTE_PREFIX);
            mem.putString(ATTR_NAME, name);
        }
        return mem;
    }

    public void putString(String key, String value) {
        IMemento mem = this.getAttribute(key);
        mem.putString(ATTR_VALUE, value);
    }

    public void putInteger(String key, int value) {
        IMemento mem = this.getAttribute(key);
        mem.putInteger(ATTR_VALUE, value);
    }

    public void putFloat(String key, float value) {
        IMemento mem = this.getAttribute(key);
        mem.putFloat(ATTR_VALUE, value);
    }

    public <T> void putList(String key, List<T> valueList) {
        if (valueList.isEmpty()) {
            this.putString(key, "");
            return;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(valueList.get(0)));
        int k = 1;
        while (k < valueList.size()) {
            sb.append(LIST_SEPARATOR).append(valueList.get(k));
            ++k;
        }
        this.putString(key, sb.toString());
    }

    public String getString(String key) {
        IMemento mem = this.getAttribute(key);
        return mem.getString(ATTR_VALUE);
    }

    public Integer getInteger(String key) {
        IMemento mem = this.getAttribute(key);
        return mem.getInteger(ATTR_VALUE);
    }

    public Float getFloat(String key) {
        IMemento mem = this.getAttribute(key);
        return mem.getFloat(ATTR_VALUE);
    }

    public List<Integer> getIntegerList(String key) {
        ArrayList<Integer> valuelist = new ArrayList<Integer>();
        String valueString = this.getString(key);
        if (valueString != null) {
            String[] objects;
            String[] stringArray = objects = valueString.split(LIST_SEPARATOR);
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                String object = stringArray[n2];
                if (StringUtils.isBlank((CharSequence)object) || "null".equals(object)) {
                    valuelist.add(0);
                } else {
                    valuelist.add(Integer.valueOf(object));
                }
                ++n2;
            }
        }
        return valuelist;
    }

    public List<String> getStringList(String key) {
        List<String> valuelist = Collections.emptyList();
        String valueString = this.getString(key);
        if (valueString != null) {
            valuelist = new ArrayList<String>(Arrays.asList(valueString.split(LIST_SEPARATOR)));
        }
        return valuelist;
    }
}

