/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.ItemColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicTableManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.MarkerColumnsUI;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.RefreshableTablePage;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutline;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlineContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.actions.RemoveViolationAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;

public class ViolationOutlinePageBR
extends Page
implements IPage,
ISelectionChangedListener,
RefreshableTablePage {
    private TableViewer tableViewer;
    private ViolationOutline violationOutline;
    private ViewerFilter viewerFilter;
    private FileRecord resource;
    private Integer[] columnWidths;
    private Integer[] sorterProperties;
    private BasicTableManager<IMarker> tableManager;
    private ItemColumnDescriptor<?, IMarker>[] initialColumns = new ItemColumnDescriptor[]{MarkerColumnsUI.PRIORITY, MarkerColumnsUI.LINE_NUMBER, MarkerColumnsUI.CREATED, MarkerColumnsUI.RULE_NAME, MarkerColumnsUI.MESSAGE};

    public ViolationOutlinePageBR(FileRecord resourceRecord, ViolationOutline outline) {
        this.resource = resourceRecord;
        this.violationOutline = outline;
        ViewerFilter[] filters = outline.getFilters();
        int i = 0;
        while (i < filters.length) {
            if (filters[i] instanceof PriorityFilter) {
                this.viewerFilter = filters[i];
            }
            ++i;
        }
    }

    @Override
    public TableViewer tableViewer() {
        return this.tableViewer;
    }

    public void createControl(Composite parent) {
        this.tableManager = new BasicTableManager("rscViolations", PMDPlugin.getDefault().loadPreferences(), this.initialColumns);
        this.tableViewer = this.tableManager.buildTableViewer(parent);
        this.tableManager.setupColumns(this.initialColumns);
        this.tableManager.setTableMenu(this.violationOutline.createContextMenu(this.tableViewer));
        this.columnWidths = new Integer[this.initialColumns.length];
        int i = 0;
        while (i < this.initialColumns.length) {
            this.columnWidths[i] = this.initialColumns[i].defaultWidth();
            final int columnIndex = i;
            this.tableViewer.getTable().getColumn(i).addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    ((ViolationOutlinePageBR)ViolationOutlinePageBR.this).columnWidths[columnIndex] = ViolationOutlinePageBR.this.tableViewer.getTable().getColumn(columnIndex).getWidth();
                }
            });
            this.tableViewer.getTable().getColumn(i).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((ViolationOutlinePageBR)ViolationOutlinePageBR.this).sorterProperties[0] = columnIndex;
                    ((ViolationOutlinePageBR)ViolationOutlinePageBR.this).sorterProperties[1] = ViolationOutlinePageBR.this.tableManager.getSortDirection();
                }
            });
            ++i;
        }
        this.sorterProperties = new Integer[2];
        this.sorterProperties[0] = null;
        this.sorterProperties[1] = 0;
        this.createActionBars();
        this.tableViewer.setContentProvider((IContentProvider)new ViolationOutlineContentProvider(this));
        this.tableViewer.setInput((Object)this.resource);
        this.tableViewer.addFilter(this.viewerFilter);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createActionBars() {
        IToolBarManager manager = this.getSite().getActionBars().getToolBarManager();
        RemoveViolationAction removeViolationAction = new RemoveViolationAction(this.tableViewer);
        manager.add((IAction)removeViolationAction);
        manager.add((IContributionItem)new Separator());
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Control getControl() {
        return this.tableViewer.getControl();
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    public FileRecord getResource() {
        return this.resource;
    }

    @Override
    public void refresh() {
        if (!this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.getControl().setRedraw(false);
            this.tableViewer.refresh();
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        IMarker marker = (IMarker)selection.getFirstElement();
        if (marker == null) {
            return;
        }
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor == null) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            if (marker.getResource().equals((Object)file)) {
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            }
        }
    }

    public List<Integer> getColumnWidths() {
        return Arrays.asList(this.columnWidths);
    }

    public void setColumnWidths(List<Integer> widths) {
        if (widths == null || widths.isEmpty()) {
            return;
        }
        if (this.tableViewer.getTable().isDisposed()) {
            return;
        }
        this.columnWidths = widths.toArray(new Integer[0]);
        TableColumn[] columns = this.tableViewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length && i < widths.size() && i < this.initialColumns.length) {
            int width = this.initialColumns[i].defaultWidth();
            if (widths.get(i) != null) {
                width = widths.get(i);
            }
            columns[i].setWidth(width);
            ++i;
        }
    }

    public List<Integer> getSorterProperties() {
        return Arrays.asList(this.sorterProperties);
    }

    public void setSorterProperties(List<Integer> sorterProps) {
        if (sorterProps == null || sorterProps.isEmpty()) {
            return;
        }
        Table table = this.tableViewer.getTable();
        if (table.isDisposed()) {
            return;
        }
        this.sorterProperties = sorterProps.toArray(new Integer[0]);
        TableColumn sortColumn = null;
        int direction = 0;
        if (sorterProps.size() == 2) {
            if (sorterProps.get(0) != null && sorterProps.get(0) >= 0 && sorterProps.get(0) < table.getColumnCount()) {
                sortColumn = table.getColumn(sorterProps.get(0).intValue());
            }
            if (sorterProps.get(1) != null) {
                direction = sorterProps.get(1);
            }
        }
        if (sortColumn != null) {
            this.tableManager.setSortDirection(sortColumn, this.initialColumns[this.sorterProperties[0]].getAccessor(), direction);
        }
    }
}

