/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutline;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlinePageBR;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class ViolationOverviewDoubleClickListener
implements IDoubleClickListener {
    private final ViolationOverview overview;

    public ViolationOverviewDoubleClickListener(ViolationOverview overview) {
        this.overview = overview;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof PackageRecord) {
            this.doubleClickToPackageRecord((PackageRecord)object);
        } else if (object instanceof FileRecord) {
            this.doubleClickToFileRecord((FileRecord)object);
        } else if (object instanceof MarkerRecord) {
            this.doubleClickToMarkerRecord((MarkerRecord)object);
        } else if (object instanceof FileToMarkerRecord) {
            this.doubleClickToFileToMarkerRecord((FileToMarkerRecord)object);
        }
    }

    private void doubleClickToFileToMarkerRecord(FileToMarkerRecord record) {
        this.openEditor((IFile)record.getResource());
        final IMarker[] markers = record.findMarkers();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViolationOverviewDoubleClickListener.this.selectMarkerInOutline(markers);
            }
        });
    }

    private void doubleClickToMarkerRecord(MarkerRecord markerRec) {
        switch (this.overview.getShowType()) {
            case 1: 
            case 2: {
                this.openEditor((IFile)markerRec.getResource());
                final IMarker[] markers = markerRec.findMarkers();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ViolationOverviewDoubleClickListener.this.selectMarkerInOutline(markers);
                    }
                });
            }
        }
        TreeViewer viewer = this.overview.getViewer();
        if (viewer.getExpandedState((Object)markerRec)) {
            viewer.collapseToLevel((Object)markerRec, 1);
        } else if (this.overview.getShowType() == 3) {
            viewer.expandToLevel((Object)markerRec, 1);
        }
    }

    private void doubleClickToFileRecord(FileRecord fileRec) {
        TreeViewer viewer = this.overview.getViewer();
        if (viewer.getExpandedState((Object)fileRec)) {
            viewer.collapseToLevel((Object)fileRec, 1);
        } else {
            viewer.expandToLevel((Object)fileRec, 1);
        }
        this.openEditor((IFile)fileRec.getResource());
    }

    private void doubleClickToPackageRecord(PackageRecord packageRec) {
        TreeViewer viewer = this.overview.getViewer();
        if (viewer.getExpandedState((Object)packageRec)) {
            viewer.collapseToLevel((Object)packageRec, -1);
        } else {
            viewer.expandToLevel((Object)packageRec, 1);
        }
    }

    private void openEditor(IFile file) {
        try {
            IDE.openEditor((IWorkbenchPage)this.overview.getSite().getPage(), (IFile)file);
        }
        catch (PartInitException pie) {
            PMDPlugin.getDefault().logError("message.error.view_exception" + this.toString(), pie);
        }
    }

    private void selectMarkerInOutline(IMarker[] markers) {
        try {
            IWorkbenchPage workbenchPage = this.overview.getSite().getPage();
            ViolationOutline view = (ViolationOutline)workbenchPage.findView("net.sourceforge.pmd.eclipse.ui.views.violationOutline");
            if (view == null) {
                view = (ViolationOutline)workbenchPage.showView("net.sourceforge.pmd.eclipse.ui.views.violationOutline");
            }
            if (view.getCurrentPage() instanceof ViolationOutlinePageBR) {
                ViolationOutlinePageBR vioPage = (ViolationOutlinePageBR)view.getCurrentPage();
                TableItem[] items = vioPage.getTableViewer().getTable().getItems();
                vioPage.getTableViewer().getTable().deselectAll();
                int j = 0;
                while (j < markers.length) {
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].getData() instanceof IMarker && markers[j].equals(items[i].getData())) {
                            vioPage.getTableViewer().getTable().select(i);
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        catch (PartInitException pie) {
            PMDPlugin.getDefault().logError("message.error.view_exception" + this.toString(), pie);
        }
    }
}

