/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractPMDAction;
import net.sourceforge.pmd.lang.rule.Rule;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public abstract class AbstractViolationSelectionAction
extends AbstractPMDAction {
    private TableViewer tableViewer;

    protected AbstractViolationSelectionAction(TableViewer viewer) {
        this.tableViewer = viewer;
        this.setEnabled(this.canExecute());
    }

    protected abstract String textId();

    protected boolean canExecute() {
        return this.hasSelections();
    }

    @Override
    protected void setupWidget() {
        super.setupWidget();
        String textId = this.textId();
        if (textId != null) {
            this.setText(AbstractViolationSelectionAction.getString(textId));
        }
    }

    protected boolean hasSelections() {
        return !this.tableViewer.getSelection().isEmpty();
    }

    protected List<Rule> getSelectedViolationRules() {
        if (!this.hasSelections()) {
            return Collections.emptyList();
        }
        IMarker[] markers = this.getSelectedViolations();
        return MarkerUtil.rulesFor(markers);
    }

    public IMarker[] getSelectedViolations() {
        ISelection selection = this.tableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            IMarker[] markers = new IMarker[structuredSelection.size()];
            Iterator i = structuredSelection.iterator();
            int index = 0;
            while (i.hasNext()) {
                markers[index++] = (IMarker)i.next();
            }
            return markers;
        }
        return MarkerUtil.EMPTY_MARKERS;
    }
}

