/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractViolationSelectionAction;
import net.sourceforge.pmd.lang.rule.Rule;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TableViewer;

public class DisableRuleAction
extends AbstractViolationSelectionAction {
    private final IPreferences preferences = PMDPlugin.getDefault().loadPreferences();

    public DisableRuleAction(TableViewer viewer) {
        super(viewer);
    }

    public static void disableRulesFor(Collection<Rule> rules, IPreferences preferences) {
        for (Rule rule : rules) {
            preferences.isActive(rule.getName(), false);
        }
        preferences.sync();
    }

    public static void removeViolationsOf(Collection<Rule> rules, Set<IProject> projects) {
        int deletions = 0;
        for (IProject project : projects) {
            for (Rule rule : rules) {
                deletions += MarkerUtil.deleteViolationsOf(rule.getName(), (IResource)project);
            }
        }
        System.out.println("Violations deleted: " + deletions);
    }

    @Override
    protected String textId() {
        return "view.action.disable.rule";
    }

    @Override
    protected String imageId() {
        return "icons/btn_disable.gif";
    }

    @Override
    protected String tooltipMsgId() {
        return "view.tooltip.disable";
    }

    public boolean hasActiveRules() {
        IMarker[] markers = this.getSelectedViolations();
        if (markers == null) {
            return false;
        }
        List<Rule> rules = MarkerUtil.rulesFor(markers);
        for (Rule rule : rules) {
            if (!this.preferences.isActive(rule.getName())) continue;
            return true;
        }
        return false;
    }

    public void run() {
        IMarker[] markers = this.getSelectedViolations();
        if (markers == null) {
            return;
        }
        DisableRuleAction.runWith(markers, this.preferences, true);
    }

    public static void runWith(final IMarker[] markers, final IPreferences preferences, final boolean removeViolations) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    List<Rule> rules = MarkerUtil.rulesFor(markers);
                    DisableRuleAction.disableRulesFor(rules, preferences);
                    if (removeViolations) {
                        DisableRuleAction.removeViolationsOf(rules, MarkerUtil.commonProjectsOf(markers));
                    }
                }
            }, null);
        }
        catch (CoreException ce) {
            DisableRuleAction.logErrorByKey("message.error.core_exception", ce);
        }
    }
}

