/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.views.actions.DisableRuleAction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class MarkerMenuFiller
extends ContributionItem {
    private final ITextEditor editor;
    private final IVerticalRulerInfo rulerInfo;
    private final List<IMarker> markers;

    public MarkerMenuFiller(ITextEditor thEditor) {
        this.editor = thEditor;
        this.rulerInfo = this.getRulerInfo();
        this.markers = this.getMarkers();
    }

    private IVerticalRulerInfo getRulerInfo() {
        return (IVerticalRulerInfo)this.editor.getAdapter(IVerticalRulerInfo.class);
    }

    private List<IMarker> getMarkers() {
        ArrayList<IMarker> clickedOnMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = this.getAllMarkers();
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (this.markerHasBeenClicked(marker)) {
                clickedOnMarkers.add(marker);
            }
            ++n2;
        }
        return clickedOnMarkers;
    }

    private boolean markerHasBeenClicked(IMarker marker) {
        return marker.getAttribute("lineNumber", 0) == this.rulerInfo.getLineOfLastMouseButtonActivity() + 1;
    }

    private IMarker[] getAllMarkers() {
        IFile sourceFile = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        try {
            return sourceFile.findMarkers(null, true, 0);
        }
        catch (CoreException coreException) {
            return MarkerUtil.EMPTY_MARKERS;
        }
    }

    public void fill(Menu menu, int index) {
        for (IMarker marker : this.markers) {
            String ruleName = marker.getAttribute("rulename", "");
            if (StringUtils.isBlank((CharSequence)ruleName)) continue;
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setText("Disable rule: " + ruleName);
            menuItem.addSelectionListener((SelectionListener)MarkerMenuFiller.createDynamicSelectionListener(marker));
        }
    }

    private static SelectionAdapter createDynamicSelectionListener(final IMarker marker) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerMenuFiller.disableRules(marker, true);
            }
        };
    }

    private static void disableRules(IMarker marker, boolean removeViolations) {
        DisableRuleAction.runWith(new IMarker[]{marker}, PMDPlugin.getDefault().loadPreferences(), removeViolations);
    }
}

