/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.util.Set;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptor;
import net.sourceforge.pmd.eclipse.ui.priority.PriorityDescriptorCache;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutline;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import net.sourceforge.pmd.lang.rule.RulePriority;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;

public class PriorityFilterAction
extends Action
implements PriorityFilter.PriorityFilterChangeListener {
    private ViolationOutline outlineView;
    private ViolationOverview overviewView;
    private PriorityFilter priorityFilter;
    private final RulePriority priority;

    private PriorityFilterAction(ViewerFilter[] filters, RulePriority thePriority) {
        this.priority = thePriority;
        this.setFilterFrom(filters);
        this.setupActionLook();
    }

    public PriorityFilterAction(RulePriority prio, ViolationOutline view) {
        this(view.getFilters(), prio);
        this.outlineView = view;
    }

    public PriorityFilterAction(RulePriority prio, ViolationOverview view) {
        this(view.getViewer().getFilters(), prio);
        this.overviewView = view;
    }

    private void setFilterFrom(ViewerFilter[] filters) {
        ViewerFilter[] viewerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof PriorityFilter) {
                this.priorityFilter = (PriorityFilter)filter;
                this.priorityFilter.addPriorityFilterChangeListener(this);
            }
            ++n2;
        }
    }

    private void setupActionLook() {
        PriorityDescriptor desc = PriorityDescriptorCache.INSTANCE.descriptorFor(this.priority);
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)desc.getImage(16)));
        this.setText(desc.label);
        String toolTip = String.format(desc.filterText, UISettings.labelFor(this.priority));
        this.setToolTipText(toolTip);
    }

    public int getStyle() {
        return 2;
    }

    public void run() {
        if (this.isChecked()) {
            this.priorityFilter.enablePriority(this.priority);
        } else {
            this.priorityFilter.disablePriority(this.priority);
        }
    }

    private void refreshView() {
        if (this.outlineView != null) {
            this.outlineView.refresh();
        } else if (this.overviewView != null) {
            this.overviewView.refresh();
        }
        RootRecord root = new RootRecord(ResourcesPlugin.getWorkspace().getRoot());
        Set<IFile> files = MarkerUtil.allMarkedFiles(root);
        PMDPlugin.getDefault().changedFiles(files);
    }

    @Override
    public void priorityEnabled(RulePriority priority) {
        if (this.priority == priority) {
            this.setChecked(true);
            this.refreshView();
        }
    }

    @Override
    public void priorityDisabled(RulePriority priority) {
        if (this.priority == priority) {
            this.setChecked(false);
            this.refreshView();
        }
    }
}

