/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractViolationSelectionAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.MarkerResolutionSelectionDialog;
import org.eclipse.ui.ide.IDE;

public class QuickFixAction
extends AbstractViolationSelectionAction {
    public QuickFixAction(TableViewer viewer) {
        super(viewer);
    }

    @Override
    protected String textId() {
        return "view.action.quickfix";
    }

    @Override
    protected String imageId() {
        return "icons/btn_quickfix.gif";
    }

    @Override
    protected String tooltipMsgId() {
        return "view.tooltip.quickfix";
    }

    public boolean hasQuickFix() {
        if (!this.hasSelections()) {
            return false;
        }
        IMarkerHelpRegistry registry = IDE.getMarkerHelpRegistry();
        IMarker[] iMarkerArray = this.getSelectedViolations();
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (!registry.hasResolutions(marker)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void run() {
        Object[] result;
        MarkerResolutionSelectionDialog dialog;
        IMarker[] selectedMarkers = this.getSelectedViolations();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(selectedMarkers[0]);
        if (resolutions.length != 0 && (dialog = new MarkerResolutionSelectionDialog(workbench.getActiveWorkbenchWindow().getShell(), resolutions)).open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
            IMarkerResolution selectedResolution = (IMarkerResolution)result[0];
            selectedResolution.run(selectedMarkers[0]);
        }
    }
}

