/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Date;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractViolationSelectionAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewAction
extends AbstractViolationSelectionAction {
    private static final Logger LOG = LoggerFactory.getLogger(ReviewAction.class);
    private IProgressMonitor monitor;

    public ReviewAction(TableViewer viewer) {
        super(viewer);
    }

    @Override
    protected String textId() {
        return "view.action.review";
    }

    @Override
    protected String imageId() {
        return "icons/btn_review.gif";
    }

    @Override
    protected String tooltipMsgId() {
        return "view.tooltip.review";
    }

    public void run() {
        final IMarker[] markers = this.getSelectedViolations();
        if (markers == null) {
            return;
        }
        final boolean reviewPmdStyle = ReviewAction.loadPreferences().isReviewPmdStyleEnabled();
        boolean go = ReviewAction.confirmForMultiples(markers, reviewPmdStyle);
        if (go) {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                dialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ReviewAction.this.setMonitor(monitor);
                        monitor.beginTask(ReviewAction.getString("monitor.review"), 5);
                        ReviewAction.this.insertReview(markers[0], reviewPmdStyle);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                ReviewAction.logErrorByKey("message.error.invocationtarget_exception", e);
            }
            catch (InterruptedException e) {
                ReviewAction.logErrorByKey("message.error.interrupted_exception", e);
            }
        }
    }

    private static boolean confirmForMultiples(IMarker[] markers, boolean reviewPmdStyle) {
        boolean go = true;
        if (markers.length > 1 && !reviewPmdStyle) {
            String title = ReviewAction.getString("message.confirm.title");
            String message = ReviewAction.getString("message.confirm.review_multiple_markers");
            Shell shell = Display.getDefault().getActiveShell();
            go = MessageDialog.openConfirm((Shell)shell, (String)title, (String)message);
        }
        return go;
    }

    protected void insertReview(IMarker marker, boolean reviewPmdStyle) {
        try {
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.exists()) {
                    String sourceCode = ReviewAction.readFile(file);
                    this.monitorWorked();
                    int offset = ReviewAction.getMarkerLineStart(sourceCode, marker.getAttribute("lineNumber", 0));
                    this.monitorWorked();
                    sourceCode = reviewPmdStyle ? ReviewAction.addPmdReviewComment(sourceCode, offset) : ReviewAction.addPluginReviewComment(sourceCode, offset, marker);
                    this.monitorWorked();
                    file.setContents((InputStream)new ByteArrayInputStream(sourceCode.getBytes(file.getCharset())), false, true, this.getMonitor());
                    this.monitorWorked();
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)ReviewAction.getString("message.error.title"), (String)("The file " + file.getName() + " doesn't exist, review aborted. Try to refresh the workspace and retry."));
                }
            }
        }
        catch (JavaModelException jme) {
            ReviewAction.ignore(jme);
        }
        catch (CoreException e) {
            ReviewAction.logErrorByKey("message.error.core_exception", e);
        }
        catch (IOException e) {
            ReviewAction.logErrorByKey("message.error.io_exception", e);
        }
    }

    private static void ignore(JavaModelException jme) {
        IJavaModelStatus status = jme.getJavaModelStatus();
        PMDPlugin.getDefault().logError((IStatus)status);
        LOG.warn("Ignoring Java Model Exception : " + status.getMessage());
        if (LOG.isDebugEnabled()) {
            LOG.debug("   code : " + status.getCode());
            LOG.debug("   severity : " + status.getSeverity());
            IJavaElement[] elements = status.getElements();
            int i = 0;
            while (i < elements.length) {
                LOG.debug("   element : " + elements[i].getElementName() + " (" + elements[i].getElementType() + ')');
                ++i;
            }
        }
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private void monitorWorked() {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(1);
        }
    }

    private static int getMarkerLineStart(String sourceCode, int lineNumber) {
        int currentLine = 1;
        int lineStart = 0;
        while (lineStart < sourceCode.length()) {
            if (currentLine == lineNumber) break;
            if (sourceCode.charAt(lineStart) == '\n') {
                ++currentLine;
            }
            ++lineStart;
        }
        if (sourceCode.charAt(lineStart) == '\r') {
            ++lineStart;
        }
        return lineStart;
    }

    public static String additionalCommentTxt() {
        String additionalCommentPattern = ReviewAction.loadPreferences().getReviewAdditionalComment();
        return MessageFormat.format(additionalCommentPattern, System.getProperty("user.name", ""), new Date());
    }

    private static String addPluginReviewComment(String sourceCode, int offset, IMarker marker) {
        StringBuilder sb = new StringBuilder(sourceCode.substring(0, offset));
        sb.append(ReviewAction.computeIndent(sourceCode, offset));
        sb.append("// @PMD:REVIEWED:");
        sb.append(MarkerUtil.ruleNameFor(marker));
        sb.append(": ").append(ReviewAction.additionalCommentTxt());
        sb.append(System.getProperty("line.separator"));
        sb.append(sourceCode.substring(offset));
        return sb.toString();
    }

    private static String addPmdReviewComment(String sourceCode, int offset) {
        String result = sourceCode;
        int index = sourceCode.substring(offset).indexOf(13);
        if (index == -1 && (index = sourceCode.substring(offset).indexOf(10)) == -1) {
            index = sourceCode.substring(offset).length();
        }
        if (sourceCode.substring(offset, index += offset).indexOf("// NOPMD") == -1) {
            StringBuilder sb = new StringBuilder(sourceCode.substring(0, index));
            sb.append(' ').append("// NOPMD");
            sb.append(' ').append(ReviewAction.additionalCommentTxt());
            sb.append(sourceCode.substring(index));
            result = sb.toString();
        }
        return result;
    }

    private static String computeIndent(String sourceCode, int offset) {
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (Character.isWhitespace(sourceCode.charAt(offset + i))) {
            indent.append(sourceCode.charAt(offset + i));
            ++i;
        }
        return indent.toString();
    }

    public static String readFile(IFile file) throws IOException, CoreException {
        String charset = file.getCharset();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader reader = new InputStreamReader(file.getContents(true), charset);){
            char[] buffer = new char[4096];
            StringBuilder sb = new StringBuilder(4096);
            while (((Reader)reader).ready()) {
                int readCount = reader.read(buffer);
                if (readCount == -1) continue;
                sb.append(buffer, 0, readCount);
            }
            return sb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

