/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractPMDAction;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class ReviewResourceAction
extends AbstractPMDAction {
    private IProgressMonitor monitor;
    private IResource resource;

    public ReviewResourceAction(IResource resource) {
        this.resource = resource;
    }

    @Override
    protected String imageId() {
        return "icons/btn_refresh.gif";
    }

    @Override
    protected String tooltipMsgId() {
        return "view.tooltip.refresh_resource";
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void run() {
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            dialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ReviewResourceAction.this.setMonitor(monitor);
                    monitor.beginTask(ReviewResourceAction.getString("monitor.review"), 5);
                    ReviewCodeCmd cmd = new ReviewCodeCmd();
                    cmd.addResource(ReviewResourceAction.this.resource);
                    cmd.setStepCount(1);
                    cmd.setUserInitiated(true);
                    try {
                        cmd.performExecute();
                    }
                    catch (RuntimeException e) {
                        ReviewResourceAction.logErrorByKey("message.error.core_exception", e);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            ReviewResourceAction.logErrorByKey("message.error.invocationtarget_exception", e);
        }
        catch (InterruptedException e) {
            ReviewResourceAction.logErrorByKey("message.error.interrupted_exception", e);
        }
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

