/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ASTContentProvider
implements ITreeContentProvider {
    private boolean includeImports;
    private boolean includeComments;
    private static final Comparator<Node> BY_LINE_NUMBER = new Comparator<Node>(){

        @Override
        public int compare(Node a, Node b) {
            return a.getBeginLine() - b.getBeginLine();
        }
    };

    public ASTContentProvider(boolean includeImportsFlag, boolean includeCommentsFlag) {
        this(Collections.emptySet());
        this.includeImports = includeImportsFlag;
        this.includeComments = includeCommentsFlag;
    }

    public ASTContentProvider(Set<Class<?>> theHiddenNodeTypes) {
    }

    public void includeImports(boolean flag) {
        this.includeImports = flag;
    }

    public void includeComments(boolean flag) {
        this.includeComments = flag;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private List<Node> withoutHiddenOnes(Object parent) {
        ArrayList<Node> kids = new ArrayList<Node>();
        if (this.includeComments && parent instanceof ASTCompilationUnit) {
            List comments = ((ASTCompilationUnit)parent).getComments();
            kids.addAll(comments.stream().map(comment -> new CommentNode((JavaComment)comment)).collect(Collectors.toList()));
        }
        AbstractNode node = (AbstractNode)parent;
        int kidCount = node.getNumChildren();
        int i = 0;
        while (i < kidCount) {
            Node kid = node.getChild(i);
            if (!(!this.includeImports && kid instanceof ASTImportDeclaration || !this.includeComments && kid instanceof CommentNode)) {
                kids.add(kid);
            }
            ++i;
        }
        Collections.sort(kids, BY_LINE_NUMBER);
        return kids;
    }

    public Object[] getElements(Object inputElement) {
        AbstractNode parent = (AbstractNode)inputElement;
        return this.withoutHiddenOnes(parent).toArray();
    }

    public Object[] getChildren(Object parentElement) {
        AbstractNode parent = (AbstractNode)parentElement;
        return this.withoutHiddenOnes(parent).toArray();
    }

    public Object getParent(Object element) {
        AbstractNode parent = (AbstractNode)element;
        return parent.getParent();
    }

    public boolean hasChildren(Object element) {
        AbstractNode parent = (AbstractNode)element;
        return parent.getNumChildren() > 0;
    }

    public static void setupSorter(TableViewer viewer) {
    }

    static class CommentNode
    extends AbstractNode<CommentNode, JavaNode> {
        private final JavaComment comment;

        CommentNode(JavaComment comment) {
            this.comment = comment;
        }

        public TextRegion getTextRegion() {
            return this.comment.getReportLocation().getRegionInFile();
        }

        public String getXPathNodeName() {
            return "comment";
        }
    }
}

