/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.util.List;
import net.sourceforge.pmd.eclipse.ui.views.ast.ASTContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.ast.CommentUtil;
import net.sourceforge.pmd.eclipse.ui.views.ast.NodeImageDeriver;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.JavadocComment;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class ASTPainterHelper {
    private Font renderFont;
    private Font italicFont;
    private TextLayout textLayout;
    private TextStyle labelStyle;
    private TextStyle imageStyle;
    private TextStyle derivedStyle;

    public ASTPainterHelper(Display display) {
        this.textLayout = new TextLayout((Device)display);
        this.renderFont = new Font((Device)display, "Tahoma", 10, 0);
        this.italicFont = new Font((Device)display, "Tahoma", 10, 2);
        this.labelStyle = new TextStyle(this.renderFont, display.getSystemColor(2), null);
        this.imageStyle = new TextStyle(this.renderFont, display.getSystemColor(9), null);
        this.derivedStyle = new TextStyle(this.italicFont, display.getSystemColor(15), null);
    }

    private String lineTextFor(ASTContentProvider.CommentNode comment) {
        StringBuilder sb = new StringBuilder();
        if (comment.getBeginLine() == comment.getEndLine()) {
            sb.append(comment.getBeginLine());
        } else {
            sb.append(comment.getBeginLine()).append('-').append(comment.getEndLine());
        }
        sb.append(' ');
        List<String> lines = CommentUtil.multiLinesIn(comment.getImage());
        String first = lines.get(0);
        if (StringUtils.isNotBlank((CharSequence)first)) {
            sb.append(first);
        }
        if (lines.size() == 1) {
            return sb.toString();
        }
        for (String line : lines) {
            if (StringUtils.isBlank((CharSequence)line)) continue;
            sb.append('|').append(line);
        }
        return sb.toString();
    }

    private TextLayout layoutFor(ASTContentProvider.CommentNode comment) {
        String label = ((Object)((Object)comment)).getClass().getSimpleName();
        int labelLength = label.length();
        String lineText = this.lineTextFor(comment);
        this.textLayout.setText(String.valueOf(label) + " " + lineText);
        this.textLayout.setStyle(this.derivedStyle, labelLength, labelLength + lineText.length());
        return this.textLayout;
    }

    private TextLayout layoutFor(JavadocComment javadoc) {
        String label = "@" + javadoc.getText();
        this.textLayout.setText(label);
        return this.textLayout;
    }

    private String textFor(AbstractNode node) {
        String txt = node.getImage();
        if (StringUtils.isNotBlank((CharSequence)txt)) {
            return txt;
        }
        if (node instanceof ASTBooleanLiteral) {
            return Boolean.toString(((ASTBooleanLiteral)node).isTrue());
        }
        return null;
    }

    public TextLayout layoutFor(TreeItem item) {
        Object data = item.getData();
        if (data instanceof ASTContentProvider.CommentNode) {
            return this.layoutFor((ASTContentProvider.CommentNode)((Object)data));
        }
        if (data instanceof JavadocComment) {
            return this.layoutFor((JavadocComment)data);
        }
        AbstractNode node = (AbstractNode)data;
        String label = node.getXPathNodeName();
        TextStyle extraStyle = this.imageStyle;
        String extra = NodeImageDeriver.derivedTextFor((Node)node);
        if (extra != null) {
            extraStyle = this.derivedStyle;
        } else {
            extra = this.textFor(node);
        }
        this.textLayout.setText(String.valueOf(label) + (extra == null ? "" : " " + extra));
        int labelLength = label.length();
        this.textLayout.setStyle(this.labelStyle, 0, labelLength);
        if (extra != null) {
            this.textLayout.setStyle(extraStyle, labelLength, labelLength + extra.length() + 1);
        }
        return this.textLayout;
    }

    public void dispose() {
        this.renderFont.dispose();
        this.italicFont.dispose();
    }
}

