/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class CommentUtil {
    private static final String CR = "\n";

    private CommentUtil() {
    }

    public static String wordAfter(String text, int position) {
        if (position >= text.length()) {
            return null;
        }
        int end = ++position;
        char ch = text.charAt(end);
        while (Character.isLetterOrDigit(ch) && end < text.length()) {
            ch = text.charAt(++end);
        }
        return text.substring(position, end);
    }

    public static Map<String, Integer> javadocTagsIn(String comment) {
        int atPos = comment.indexOf(64);
        if (atPos < 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> tags = new HashMap<String, Integer>();
        while (atPos >= 0) {
            String tag = CommentUtil.wordAfter(comment, atPos);
            tags.put(tag, atPos);
            atPos = comment.indexOf(64, atPos + tag.length());
        }
        return tags;
    }

    public static List<String> multiLinesIn(String comment) {
        String[] lines = comment.split(CR);
        ArrayList<String> filteredLines = new ArrayList<String>(lines.length);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String rawLine = stringArray[n2];
            String line = rawLine.trim();
            if (line.startsWith("//")) {
                filteredLines.add(line.substring(2));
            } else if (line.endsWith("*/")) {
                int end = line.length() - 2;
                int start = line.startsWith("/**") ? 3 : (line.startsWith("/*") ? 2 : 0);
                filteredLines.add(line.substring(start, end));
            } else if (line.charAt(0) == '*') {
                filteredLines.add(line.substring(1));
            } else if (line.startsWith("/**")) {
                filteredLines.add(line.substring(3));
            } else if (line.startsWith("/*")) {
                filteredLines.add(line.substring(2));
            } else {
                filteredLines.add(line);
            }
            ++n2;
        }
        return filteredLines;
    }

    public static List<String> trim(List<String> lines) {
        int firstNonEmpty = 0;
        while (firstNonEmpty < lines.size()) {
            if (StringUtils.isNotBlank((CharSequence)lines.get(firstNonEmpty))) break;
            ++firstNonEmpty;
        }
        if (firstNonEmpty == lines.size()) {
            return Collections.emptyList();
        }
        int lastNonEmpty = lines.size() - 1;
        while (lastNonEmpty > 0) {
            if (StringUtils.isNotBlank((CharSequence)lines.get(lastNonEmpty))) break;
            --lastNonEmpty;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        int i = firstNonEmpty;
        while (i < lastNonEmpty) {
            filtered.add(lines.get(i));
            ++i;
        }
        return filtered;
    }

    public static void main(String[] args) {
        Set<String> tags = CommentUtil.javadocTagsIn(args[0]).keySet();
        for (String tag : tags) {
            System.out.println(tag);
        }
    }
}

