/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.eclipse.ui.views.ast.ASTUtil;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.JavaComment;

public class NodeImageDeriver {
    private static final NodeImageDeriver COMPILATION_UNIT_DERIVER = new NodeImageDeriver((Class)ASTCompilationUnit.class){

        @Override
        public String deriveFrom(Node node) {
            NodeImageDeriver.dumpComments((ASTCompilationUnit)node);
            return "Comments: " + ((ASTCompilationUnit)node).getComments().size();
        }
    };
    private static final NodeImageDeriver IMPORT_DERIVER = new NodeImageDeriver((Class)ASTImportDeclaration.class){

        @Override
        public String deriveFrom(Node node) {
            return ((ASTImportDeclaration)node).getImportedName();
        }
    };
    private static final NodeImageDeriver METHOD_DECLARATION_DERIVER = new NodeImageDeriver((Class)ASTMethodDeclaration.class){

        @Override
        public String deriveFrom(Node node) {
            return ASTUtil.getMethodLabel((ASTMethodDeclaration)node, true);
        }
    };
    private static final NodeImageDeriver THROW_STATEMENT_DERIVER = new NodeImageDeriver((Class)ASTThrowStatement.class){

        @Override
        public String deriveFrom(Node node) {
            ASTClassType t = (ASTClassType)node.descendants(ASTClassType.class).first();
            return t == null ? null : t.getSimpleName();
        }
    };
    private static final NodeImageDeriver FIELD_DECLARATION_DERIVER = new NodeImageDeriver((Class)ASTFieldDeclaration.class){

        @Override
        public String deriveFrom(Node node) {
            return ASTUtil.getFieldLabel((ASTFieldDeclaration)node);
        }
    };
    private static final NodeImageDeriver LOCAL_VARIABLE_DECLARATION_DERIVER = new NodeImageDeriver((Class)ASTLocalVariableDeclaration.class){

        @Override
        public String deriveFrom(Node node) {
            return ASTUtil.getLocalVarDeclarationLabel((ASTLocalVariableDeclaration)node);
        }
    };
    private static final NodeImageDeriver ANNOTATION_DERIVER = new NodeImageDeriver((Class)ASTAnnotation.class){

        @Override
        public String deriveFrom(Node node) {
            return ASTUtil.getAnnotationLabel((ASTAnnotation)node);
        }
    };
    private static final NodeImageDeriver[] ALL_DERIVERS = new NodeImageDeriver[]{IMPORT_DERIVER, METHOD_DECLARATION_DERIVER, LOCAL_VARIABLE_DECLARATION_DERIVER, FIELD_DECLARATION_DERIVER, ANNOTATION_DERIVER, COMPILATION_UNIT_DERIVER, THROW_STATEMENT_DERIVER};
    private static final Map<Class<?>, NodeImageDeriver> DERIVERS_BY_TYPE = new HashMap(ALL_DERIVERS.length);
    public final Class<?> target;

    static {
        NodeImageDeriver[] nodeImageDeriverArray = ALL_DERIVERS;
        int n = ALL_DERIVERS.length;
        int n2 = 0;
        while (n2 < n) {
            NodeImageDeriver deriver = nodeImageDeriverArray[n2];
            DERIVERS_BY_TYPE.put(deriver.target, deriver);
            ++n2;
        }
    }

    public NodeImageDeriver(Class<?> theASTClass) {
        this.target = theASTClass;
    }

    public String deriveFrom(Node node) {
        return null;
    }

    private static void dumpComments(ASTCompilationUnit node) {
        for (JavaComment comment : node.getComments()) {
            System.out.println(comment.getClass().getName());
            System.out.println(comment.getText());
        }
    }

    public static String derivedTextFor(Node node) {
        NodeImageDeriver deriver = DERIVERS_BY_TYPE.get(node.getClass());
        return deriver == null ? null : deriver.deriveFrom(node);
    }
}

