/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.util.List;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.eclipse.ui.actions.RuleSetUtil;
import net.sourceforge.pmd.eclipse.util.internal.SpyingRule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;

public final class XPathEvaluator {
    private static final FileId SNIPPET_FILENAME = FileId.fromPathLikeString((String)"snippet.java");
    public static final XPathEvaluator INSTANCE = new XPathEvaluator();

    private XPathEvaluator() {
    }

    public Node getCompilationUnit(String source) {
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.setIgnoreIncrementalAnalysis(true);
        configuration.setForceLanguageVersion(this.getLanguageVersion());
        SpyingRule rule = new SpyingRule();
        rule.setLanguage(this.getLanguageVersion().getLanguage());
        RuleSet ruleset = RuleSetUtil.newSingle((Rule)rule);
        Throwable throwable = null;
        Object var6_7 = null;
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)configuration);){
            pmd.addRuleSet(ruleset);
            pmd.files().addSourceFile(SNIPPET_FILENAME, source);
            pmd.performAnalysis();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return rule.getRootNode();
    }

    private LanguageVersion getLanguageVersion() {
        return JavaLanguageModule.getInstance().getDefaultVersion();
    }

    public List<RuleViolation> evaluate(String source, String xpathQuery, String xpathVersion) {
        XPathRule xpathRule = new XPathRule(XPathVersion.ofId((String)xpathVersion), xpathQuery);
        RuleSet ruleSet = RuleSet.forSingleRule((Rule)xpathRule);
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.setIgnoreIncrementalAnalysis(true);
        configuration.setForceLanguageVersion(this.getLanguageVersion());
        Throwable throwable = null;
        Object var8_9 = null;
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)configuration);){
            pmd.addRuleSet(ruleSet);
            pmd.files().addSourceFile(SNIPPET_FILENAME, source);
            Report report = pmd.performAnalysisAndCollectReport();
            return report.getViolations();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

