/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.cpd;

import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.internal.CpdMarkWithSourceCode;
import net.sourceforge.pmd.eclipse.runtime.cmd.internal.CpdMatchWithSourceCode;
import net.sourceforge.pmd.eclipse.ui.views.cpd.CPDView;
import net.sourceforge.pmd.lang.document.FileLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class CPDViewDoubleClickEventListener
implements IDoubleClickListener {
    private final CPDView view;

    public CPDViewDoubleClickEventListener(CPDView view) {
        this.view = view;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object object = selection.getFirstElement();
        TreeNode node = (TreeNode)object;
        Object value = node.getValue();
        TreeViewer treeViewer = this.view.getTreeViewer();
        if (value instanceof CpdMatchWithSourceCode) {
            if (treeViewer.getExpandedState((Object)node)) {
                treeViewer.collapseToLevel((Object)node, -1);
            } else {
                treeViewer.expandToLevel((Object)node, 1);
            }
        } else if (value instanceof CpdMarkWithSourceCode) {
            CpdMarkWithSourceCode entry = (CpdMarkWithSourceCode)value;
            CpdMatchWithSourceCode match = (CpdMatchWithSourceCode)node.getParent().getValue();
            this.highlightText(match, entry);
        }
    }

    private void highlightText(CpdMatchWithSourceCode matchWithSource, CpdMarkWithSourceCode markWithSource) {
        Match match = matchWithSource.getMatch();
        Mark entry = markWithSource.getMark();
        FileLocation location = entry.getLocation();
        IPath path = Path.fromOSString((String)location.getFileId().getOriginalPath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (file == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.view.getSite().getPage();
            IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            if (part instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)part;
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                int offset = document.getLineOffset(location.getStartLine() - 1);
                int length = document.getLineOffset(location.getStartLine() - 1 + match.getLineCount()) - offset - 1;
                textEditor.selectAndReveal(offset, length);
            }
        }
        catch (BadLocationException | PartInitException pie) {
            PMDPlugin.getDefault().logError(this.getString("message.error.view_exception"), pie);
        }
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

