/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.cpd;

import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.eclipse.runtime.cmd.internal.CpdMarkWithSourceCode;
import net.sourceforge.pmd.eclipse.runtime.cmd.internal.CpdMatchWithSourceCode;
import net.sourceforge.pmd.lang.document.FileLocation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CPDViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        TreeNode node = (TreeNode)element;
        Object value = node.getValue();
        if (columnIndex == 1) {
            if (value instanceof CpdMatchWithSourceCode) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            } else if (value instanceof CpdMarkWithSourceCode) {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER");
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        TreeNode node = (TreeNode)element;
        Object value = node.getValue();
        String result = "";
        switch (columnIndex) {
            case 2: {
                if (value instanceof CpdMatchWithSourceCode) {
                    CpdMatchWithSourceCode data = (CpdMatchWithSourceCode)value;
                    Match match = data.getMatch();
                    StringBuilder buffer = new StringBuilder(50);
                    buffer.append("Found suspect cut & paste (");
                    buffer.append(match.getMarkCount()).append(" matches,");
                    buffer.append(match.getLineCount());
                    if (match.getLineCount() == 1) {
                        buffer.append(" line)");
                    } else {
                        buffer.append(" lines)");
                    }
                    result = buffer.toString();
                    break;
                }
                if (!(value instanceof CpdMarkWithSourceCode)) break;
                CpdMarkWithSourceCode data = (CpdMarkWithSourceCode)value;
                Mark entry = data.getMark();
                FileLocation location = entry.getLocation();
                Match match = ((CpdMatchWithSourceCode)node.getParent().getValue()).getMatch();
                int startLine = location.getStartLine();
                int endLine = location.getStartLine() + match.getLineCount() - 1;
                IPath path = Path.fromOSString((String)location.getFileId().getOriginalPath());
                StringBuilder buffer = new StringBuilder(100);
                if (startLine == endLine) {
                    buffer.append("line ").append(startLine);
                } else {
                    buffer.append("lines ").append(startLine).append('-').append(endLine);
                }
                buffer.append(" in file ").append(path.lastSegment());
                result = buffer.toString();
                break;
            }
            case 3: {
                if (!(value instanceof CpdMarkWithSourceCode)) break;
                CpdMarkWithSourceCode data = (CpdMarkWithSourceCode)value;
                IPath path = Path.fromOSString((String)data.getMark().getLocation().getFileId().getOriginalPath());
                IContainer resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
                if (resource == null) break;
                result = resource.getProjectRelativePath().removeFileExtension().toString().replace('/', '.');
            }
        }
        return result;
    }
}

