/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.cpd2;

import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.cpd2.CPDView2;
import net.sourceforge.pmd.eclipse.ui.views.cpd2.CPDViewLabelProvider2;
import net.sourceforge.pmd.lang.document.FileLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class CPDViewTooltipListener2
implements Listener {
    private final CPDView2 view;
    private Cursor normalCursor;
    private Cursor handCursor;

    public CPDViewTooltipListener2(CPDView2 view) {
        this.view = view;
        this.initialize();
    }

    private void initialize() {
        Display disp = Display.getDefault();
        this.normalCursor = disp.getSystemCursor(0);
        this.handCursor = disp.getSystemCursor(21);
    }

    private void highlight(Match match, Mark entry) {
        FileLocation location = entry.getLocation();
        IPath path = Path.fromOSString((String)location.getFileId().getOriginalPath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (file == null) {
            return;
        }
        try {
            IWorkbenchPage page = this.view.getSite().getPage();
            IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            if (part instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)part;
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                int offset = document.getLineOffset(location.getStartLine() - 1);
                int length = document.getLineOffset(location.getStartLine() - 1 + match.getLineCount()) - offset - 1;
                textEditor.selectAndReveal(offset, length);
            }
        }
        catch (BadLocationException | PartInitException pie) {
            PMDPlugin.getDefault().logError(this.getString("message.error.view_exception"), pie);
        }
    }

    private static Match matchAt(TreeItem treeItem) {
        Object item = ((TreeNode)treeItem.getData()).getValue();
        return item instanceof Match ? (Match)item : null;
    }

    private Mark itemAt(TreeItem treeItem, Point location) {
        if (treeItem == null) {
            return null;
        }
        Object item = ((TreeNode)treeItem.getData()).getValue();
        if (!(item instanceof Match)) {
            return null;
        }
        String[] names = CPDViewLabelProvider2.sourcesFor((Match)item);
        location.x -= this.view.widthOf(0);
        int colWidth = this.view.widthOf(1);
        int cellWidth = colWidth / names.length;
        int i = 0;
        while (i < names.length) {
            int classWidth;
            int rightEdge = colWidth - cellWidth * i;
            int[] widths = this.view.widthsFor(names[i]);
            if (widths != null && location.x > rightEdge - (classWidth = widths[1]) && location.x < rightEdge) {
                return CPDViewLabelProvider2.entriesFor((Match)item)[i];
            }
            ++i;
        }
        return null;
    }

    public void handleEvent(Event event) {
        Tree tree = this.view.getTreeViewer().getTree();
        Point location = new Point(event.x, event.y);
        Shell shell = tree.getShell();
        if (this.view.inColumn(location) != 1) {
            shell.setCursor(this.normalCursor);
            return;
        }
        TreeItem item = tree.getItem(location);
        Mark entry = this.itemAt(item, location);
        if (entry == null) {
            shell.setCursor(this.normalCursor);
            return;
        }
        switch (event.type) {
            case 3: {
                this.highlight(CPDViewTooltipListener2.matchAt(item), entry);
                break;
            }
            case 5: 
            case 32: {
                shell.setCursor(this.handCursor);
                break;
            }
        }
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

