/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.dataflow;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DataflowAnomalyTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String KEY_IMAGE_DFA = "error_dfa";

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            image = PMDPlugin.getDefault().getImage(KEY_IMAGE_DFA, "icons/lab_errdfa.gif");
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof RuleViolation) {
            RuleViolation violation = (RuleViolation)element;
            switch (columnIndex) {
                case 0: {
                    return "daa rule violation";
                }
                case 1: {
                    int line1 = violation.getBeginLine();
                    int line2 = violation.getEndLine();
                    if (line1 == line2 || line2 == 0) {
                        return String.valueOf(line1);
                    }
                    if (line2 < line1) {
                        int temp = line1;
                        line1 = line2;
                        line2 = temp;
                    }
                    return String.valueOf(line1) + ", " + line2;
                }
                case 2: {
                    return (String)violation.getAdditionalInfo().get("variableName");
                }
                case 3: {
                    return (String)violation.getAdditionalInfo().get("methodName");
                }
            }
            return "";
        }
        return "";
    }
}

