/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.dataflow;

import java.util.List;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraphTableData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class DataflowGraphTable
extends Composite
implements PaintListener {
    private int numRows = 0;
    private int numCols = 0;
    private Integer[] colWidths;
    private Integer rowHeight;
    private Color bgColor;
    private Color fgColor;
    private Color lineColor;
    protected Composite header;
    protected Composite bodyFrame;
    protected Composite bodyArea;
    protected Composite graphArea;
    protected Point tablePosition;
    protected Point tableSize;
    protected int graphColumn = 1;
    protected static final Color DEFAULT_BG_COLOR = new Color(null, 255, 255, 255);
    protected static final Color DEFAULT_FG_COLOR = new Color(null, 0, 0, 0);
    protected static final Color DEFAULT_LINE_COLOR = new Color(null, 192, 192, 192);
    protected static final int DEFAULT_ROW_HEIGHT = 20;
    protected static final int DEFAULT_COL_WIDTH = 100;

    public DataflowGraphTable(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(1808));
        this.header = this.buildTableHeader(this);
        Composite[] tableBody = this.buildTableBody(this);
        this.bodyFrame = tableBody[0];
        this.bodyArea = tableBody[1];
        this.bodyFrame.addPaintListener((PaintListener)this);
        this.bodyArea.addPaintListener((PaintListener)this);
        this.bodyFrame.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                DataflowGraphTable.this.redraw();
            }
        });
        this.initScrollBars(this.bodyFrame);
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.horizontalSpacing = 0;
        mainLayout.verticalSpacing = 0;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        this.setLayout((Layout)mainLayout);
    }

    private Composite buildTableHeader(Composite parent) {
        Composite headerCanvas = new Composite(parent, 0);
        headerCanvas.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        headerCanvas.setLayout((Layout)layout);
        return headerCanvas;
    }

    private Composite[] buildTableBody(Composite parent) {
        Composite frameCanvas = new Composite(parent, 768);
        frameCanvas.setLayoutData((Object)new GridData(1808));
        Composite bodyCanvas = new Composite(frameCanvas, 0);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        bodyCanvas.setLayoutData((Object)data);
        bodyCanvas.setSize(this.numCols * 100, this.numRows * 20);
        int spacing = 10;
        GridLayout bodyLayout = new GridLayout(this.numCols, false);
        bodyLayout.marginHeight = spacing / 2;
        bodyLayout.marginWidth = spacing / 2;
        bodyLayout.horizontalSpacing = spacing;
        bodyLayout.verticalSpacing = spacing;
        bodyCanvas.setLayout((Layout)bodyLayout);
        GridLayout frameLayout = new GridLayout(1, false);
        frameLayout.horizontalSpacing = 0;
        frameLayout.verticalSpacing = 0;
        frameLayout.marginWidth = 0;
        frameLayout.marginHeight = 0;
        frameCanvas.setLayout((Layout)frameLayout);
        this.tablePosition = new Point(bodyCanvas.getLocation().x, bodyCanvas.getLocation().y);
        this.tableSize = new Point(bodyCanvas.getSize().x, bodyCanvas.getSize().y);
        return new Composite[]{frameCanvas, bodyCanvas};
    }

    public void setColumns(int[] widths, String[] titles, int graphPos) {
        this.numCols = widths.length;
        this.colWidths = new Integer[this.numCols];
        int i = 0;
        while (i < widths.length) {
            this.colWidths[i] = widths[i];
            ++i;
        }
        if (graphPos >= 0 && graphPos <= this.numCols) {
            this.graphColumn = graphPos;
        }
        String[] headerTitles = this.getHeaderTitles(titles);
        GridLayout headerLayout = (GridLayout)this.header.getLayout();
        headerLayout.numColumns = this.numCols + 1;
        int i2 = 0;
        while (i2 <= this.numCols) {
            Button button = new Button(this.header, 0);
            GridData data = new GridData();
            if (i2 < this.numCols) {
                button.setText(headerTitles[i2]);
                data.widthHint = widths[i2];
            } else if (i2 == this.numCols) {
                data.grabExcessHorizontalSpace = true;
                data.horizontalAlignment = 4;
            }
            button.setLayoutData((Object)data);
            ++i2;
        }
        int newWidth = 0;
        int k = 0;
        while (k < widths.length) {
            newWidth += this.colWidths[k].intValue();
            ++k;
        }
        ((GridLayout)this.bodyArea.getLayout()).numColumns = this.numCols;
        this.tableSize.x = newWidth;
        this.redraw();
    }

    private String[] getHeaderTitles(String[] givenTitles) {
        String[] headerTitles = new String[this.numCols];
        if (givenTitles == null) {
            int i = 0;
            while (i < this.numCols) {
                headerTitles[i] = "";
                ++i;
            }
        } else if (givenTitles.length < this.numCols) {
            int remain = this.numCols - givenTitles.length;
            int j = 0;
            while (j < givenTitles.length) {
                headerTitles[j] = givenTitles[j];
                ++j;
            }
            int k = 0;
            while (k < remain) {
                headerTitles[givenTitles.length + k] = "";
                ++k;
            }
        } else {
            headerTitles = givenTitles;
        }
        return headerTitles;
    }

    public void setRows(int count, int height) {
        this.numRows = count;
        this.rowHeight = height;
        this.tableSize.y = this.numRows * height;
        this.redraw();
    }

    public void setColors(Color foreGround, Color backGround, Color line) {
        this.fgColor = foreGround;
        this.bgColor = backGround;
        this.lineColor = line;
        this.bodyArea.setBackground(this.bgColor);
        this.bodyArea.setForeground(this.fgColor);
        this.redraw();
    }

    public void setTableData(List<List<DataflowGraphTableData>> data) {
        this.buildTableData(this.bodyArea, data);
        this.redraw();
    }

    public Composite getGraphArea() {
        return this.graphArea;
    }

    public void redraw() {
        Point bodySize = this.bodyFrame.getSize();
        Point parentSize = this.getParent().getSize();
        Point empty = new Point(0, 0);
        if (bodySize.equals((Object)empty) && !parentSize.equals((Object)empty)) {
            this.bodyFrame.setSize(parentSize);
        }
        this.syncScrollBars(this.bodyFrame);
        this.syncViewPosition(this.bodyFrame);
        this.syncHeader();
        super.redraw();
    }

    private void initScrollBars(Composite parent) {
        ScrollBar horizontal = parent.getHorizontalBar();
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataflowGraphTable.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        ScrollBar vertical = parent.getVerticalBar();
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataflowGraphTable.this.scrollVertically((ScrollBar)event.widget);
            }
        });
    }

    private void syncScrollBars(Composite source) {
        int sourceWidth = source.getSize().x - source.getVerticalBar().getSize().x;
        int sourceHeight = source.getSize().y - source.getHorizontalBar().getSize().y;
        ScrollBar horizontalBar = this.bodyFrame.getHorizontalBar();
        ScrollBar verticalBar = this.bodyFrame.getVerticalBar();
        horizontalBar.setEnabled(true);
        verticalBar.setEnabled(true);
        if (sourceWidth >= this.tableSize.x) {
            horizontalBar.setEnabled(false);
        } else {
            horizontalBar.setMaximum(this.tableSize.x);
            horizontalBar.setIncrement(this.tableSize.x / 100);
            horizontalBar.setPageIncrement(this.tableSize.x);
            horizontalBar.setThumb(sourceWidth);
        }
        if (sourceHeight >= this.tableSize.y) {
            verticalBar.setEnabled(false);
        } else {
            verticalBar.setMaximum(this.tableSize.y);
            verticalBar.setIncrement(this.tableSize.y / 100);
            verticalBar.setPageIncrement(this.tableSize.y);
            verticalBar.setThumb(sourceHeight);
        }
    }

    private void syncViewPosition(Composite source) {
        this.tablePosition.x = -this.bodyFrame.getHorizontalBar().getSelection();
        this.tablePosition.y = -this.bodyFrame.getVerticalBar().getSelection();
        int viewWidth = source.getSize().x - source.getVerticalBar().getSize().x;
        int viewHeight = source.getSize().y - source.getHorizontalBar().getSize().y;
        if (viewWidth > this.tableSize.x) {
            this.tablePosition.x = 0;
        }
        if (viewHeight > this.tableSize.y) {
            this.tablePosition.y = 0;
        }
    }

    protected void syncHeader() {
        Control[] buttons = this.header.getChildren();
        int width = 0;
        int k = 0;
        while (k < buttons.length) {
            Button button = (Button)buttons[k];
            button.setLocation(this.tablePosition.x + width, button.getLocation().y);
            width += button.getSize().x;
            if (k == buttons.length - 1) {
                button.setSize(button.getSize().x - this.tablePosition.x, button.getSize().y);
            }
            ++k;
        }
    }

    protected void scrollHorizontally(ScrollBar bar) {
        int x = bar.getSelection();
        int y = this.bodyArea.getLocation().y;
        this.bodyArea.setLocation(-x, y);
        this.tablePosition.x = -x;
        this.syncHeader();
    }

    protected void scrollVertically(ScrollBar bar) {
        int x = this.bodyArea.getLocation().x;
        int y = bar.getSelection();
        this.bodyArea.setLocation(x, -y);
        this.tablePosition.y = -y;
    }

    public void paintControl(PaintEvent e) {
        Composite source = (Composite)e.getSource();
        this.bodyArea.getClientArea().width = this.tableSize.x;
        this.bodyArea.getClientArea().height = this.tableSize.y;
        this.bodyArea.setSize(this.tableSize);
        this.bodyArea.setLocation(this.tablePosition);
        if (source.equals(this.bodyFrame)) {
            this.buildFrameLines(e.gc);
        } else if (source.equals(this.bodyArea)) {
            this.buildBodyLines(e.gc);
            this.clearGraphArea(e.gc);
            this.bodyFrame.redraw();
        }
    }

    protected void clearGraphArea(GC g) {
        if (this.colWidths == null || this.rowHeight == null) {
            return;
        }
        int xPos = 0;
        if (this.graphColumn > 0) {
            int i = 0;
            while (i < this.graphColumn) {
                xPos += this.colWidths[i].intValue();
                ++i;
            }
        }
        int width = this.colWidths[this.graphColumn];
        int height = this.numRows * this.rowHeight;
        if (this.bgColor == null) {
            this.bgColor = DEFAULT_BG_COLOR;
        }
        g.setBackground(this.bgColor);
        g.fillRectangle(xPos, 1, width - 1, height);
        g.setBackground(this.bgColor);
    }

    protected void buildBodyLines(GC g) {
        if (this.lineColor == null) {
            this.lineColor = DEFAULT_LINE_COLOR;
        }
        g.setForeground(this.lineColor);
        if (this.rowHeight == null) {
            this.rowHeight = 20;
        }
        int rowWidth = this.tableSize.x;
        int i = 0;
        while (i <= this.numRows) {
            g.drawLine(0, i * this.rowHeight, rowWidth, i * this.rowHeight);
            ++i;
        }
        int colHeight = this.tableSize.y;
        int width = 0;
        int j = 0;
        while (j < this.numCols) {
            width = this.colWidths == null ? (width += 100) : (width += this.colWidths[j].intValue());
            g.drawLine(width - 1, 0, width - 1, colHeight);
            ++j;
        }
    }

    protected void buildFrameLines(GC g) {
        int viewHeight;
        int viewWidth;
        if (this.bgColor == null) {
            this.bgColor = DEFAULT_BG_COLOR;
        }
        this.bodyFrame.setBackground(this.bgColor);
        if (this.lineColor == null) {
            this.lineColor = DEFAULT_LINE_COLOR;
        }
        g.setForeground(this.lineColor);
        int tableX = this.tablePosition.x;
        int tableY = this.tablePosition.y;
        if (this.rowHeight == null) {
            this.rowHeight = 20;
        }
        if ((viewWidth = this.bodyFrame.getSize().x) > this.tableSize.x) {
            int i = 0;
            while (i < this.numRows) {
                g.drawLine(this.tableSize.x, tableY + i * this.rowHeight, viewWidth, tableY + i * this.rowHeight);
                ++i;
            }
        }
        if ((viewHeight = this.bodyFrame.getSize().y) > this.tableSize.y) {
            int yPos = tableY + this.tableSize.y;
            while (yPos < viewHeight) {
                g.drawLine(0, yPos, viewWidth, yPos);
                yPos += this.rowHeight.intValue();
            }
            yPos = tableY + this.tableSize.y;
            int width = 0;
            int j = 0;
            while (j < this.numCols) {
                width = this.colWidths == null ? (width += 100) : (width += this.colWidths[j].intValue());
                g.drawLine(tableX + width - 1, yPos, tableX + width - 1, viewHeight);
                ++j;
            }
        }
    }

    private void buildTableData(Composite table, List<List<DataflowGraphTableData>> tableData) {
        if (this.bgColor == null) {
            this.bgColor = DEFAULT_BG_COLOR;
        }
        if (this.fgColor == null) {
            this.fgColor = DEFAULT_FG_COLOR;
        }
        int hSpace = ((GridLayout)table.getLayout()).horizontalSpacing;
        int vSpace = ((GridLayout)table.getLayout()).verticalSpacing;
        int i = 0;
        while (i < tableData.size()) {
            List<DataflowGraphTableData> rowData = tableData.get(i);
            int xPos = 0;
            int j = 0;
            while (j < this.numCols) {
                DataflowGraphTableData data = rowData.get(j);
                String text = "";
                int style = 0;
                if (data != null) {
                    text = data.getData().toString();
                    style = data.getStyle();
                }
                int width = this.colWidths[j] - hSpace;
                int height = this.rowHeight - vSpace;
                if (j == this.graphColumn) {
                    if (i == 0) {
                        this.graphArea = this.createGraphArea(table, new Point(width, this.numRows * height));
                    } else {
                        xPos += this.colWidths[j].intValue();
                    }
                } else {
                    this.createLabel(table, style, text, this.bgColor, this.fgColor, new Point(xPos, i * this.rowHeight), new Point(width, height));
                    xPos += this.colWidths[j].intValue();
                }
                ++j;
            }
            ++i;
        }
    }

    protected void createLabel(Composite parent, int style, String text, Color bgColor, Color fgColor, Point coord, Point size) {
        Label label = new Label(parent, style);
        GridData data = new GridData();
        data.widthHint = size.x;
        data.heightHint = size.y;
        label.setLayoutData((Object)data);
        label.setLocation(coord.x, coord.y);
        label.setBackground(bgColor);
        label.setText(text == null ? "" : text);
    }

    private Composite createGraphArea(Composite parent, Point size) {
        Composite graphCanvas = new Composite(parent, 0);
        GridData data = new GridData(1040);
        data.widthHint = size.x;
        data.heightHint = size.y;
        data.verticalSpan = this.numRows;
        graphCanvas.setLayoutData((Object)data);
        graphCanvas.setSize(size);
        graphCanvas.setLayout((Layout)new FillLayout());
        return graphCanvas;
    }
}

