/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.dataflow;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraph;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraphTable;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraphTableData;
import net.sourceforge.pmd.lang.ast.Node;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class DataflowGraphViewer
extends Composite {
    private Node method;
    private DataflowGraphTable table;
    private DataflowGraph graph;
    protected static final int NODE_RADIUS = 12;
    protected static final int LINE_LENGTH = 25;
    protected static final int ROW_HEIGHT = 49;
    protected int[] colWidths;
    protected Color bgColor;
    protected Color lineColor;
    protected Color textColor;

    public DataflowGraphViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(1808));
        this.table = this.initTable(this, style);
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.horizontalSpacing = 0;
        mainLayout.verticalSpacing = 0;
        this.setLayout((Layout)mainLayout);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.graph != null) {
            this.graph.addMouseListener(mouseListener);
        }
    }

    private DataflowGraphTable initTable(Composite parent, int style) {
        DataflowGraphTable dfaTable = new DataflowGraphTable(parent, style);
        this.colWidths = new int[]{50, 250, 70, 220, 300};
        String[] headerTitles = new String[]{this.getString("view.dataflow.graph.column_line"), this.getString("view.dataflow.graph.column_graph"), this.getString("view.dataflow.graph.column_nextnodes"), this.getString("view.dataflow.graph.column_values"), this.getString("view.dataflow.graph.column_code")};
        dfaTable.setColumns(this.colWidths, headerTitles, 1);
        Display display = parent.getDisplay();
        this.bgColor = display.getSystemColor(1);
        this.lineColor = new Color(null, 192, 192, 192);
        this.textColor = display.getSystemColor(2);
        dfaTable.setColors(this.textColor, this.bgColor, this.lineColor);
        return dfaTable;
    }

    public void setData(Node node, String resString) {
        if (this.method != null) {
            this.table.dispose();
            this.table = this.initTable(this, 0);
            this.layout();
        }
        this.method = node;
        this.table.setRows(1, 49);
        this.table.setTableData(this.createDataFields(node));
        this.graph = new DataflowGraph(this.table.getGraphArea(), node, 12, 25, 49);
    }

    public DataflowGraph getGraph() {
        return this.graph;
    }

    protected List<List<DataflowGraphTableData>> createDataFields(Node node) {
        return new ArrayList<List<DataflowGraphTableData>>();
    }

    protected String getCodeLine(String code, int line) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (LineNumberReader reader = new LineNumberReader(new StringReader(code));){
                while (reader.ready()) {
                    String retString = reader.readLine();
                    if (reader.getLineNumber() != line) continue;
                    return retString;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
        }
        return null;
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

