/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.dataflow;

import java.util.Iterator;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.AbstractStructureInspectorPage;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowAnomalyTableContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowAnomalyTableLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowAnomalyTableViewer;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraph;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraphViewer;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;

public class DataflowViewPage
extends AbstractStructureInspectorPage
implements IPropertyListener {
    private Composite dfaFrame;
    private Button switchButton;
    protected DataflowGraphViewer graphViewer;
    protected DataflowAnomalyTableViewer tableViewer;
    private boolean isTableShown;
    private boolean isTableRefreshed;

    public DataflowViewPage(IWorkbenchPart part, FileRecord record) {
        super(part, record);
    }

    public void createControl(Composite parent) {
        this.dfaFrame = new Composite(parent, 0);
        Composite titleArea = new Composite(this.dfaFrame, 0);
        GridData tableData = new GridData(768);
        tableData.horizontalSpan = 2;
        titleArea.setLayoutData((Object)tableData);
        titleArea.setLayout((Layout)new GridLayout(4, false));
        Label methodLabel = new Label(titleArea, 0);
        methodLabel.setText("Method: ");
        this.buildMethodSelector(titleArea);
        Label label = new Label(titleArea, 0);
        label.setLayoutData((Object)new GridData(768));
        this.switchButton = new Button(titleArea, 131072);
        this.switchButton.setLayoutData((Object)new GridData(130, 25));
        this.switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DataflowViewPage.this.isTableShown = !DataflowViewPage.this.isTableShown;
                DataflowViewPage.this.showTableArea(DataflowViewPage.this.isTableShown);
                if (!DataflowViewPage.this.isTableShown) {
                    if (DataflowViewPage.this.graphViewer == null || DataflowViewPage.this.graphViewer.getGraph() == null) {
                        return;
                    }
                    DataflowGraph graph = DataflowViewPage.this.graphViewer.getGraph();
                    if (graph.isMarked()) {
                        graph.demark();
                    }
                }
            }
        });
        this.switchButton.setText(DataflowViewPage.getString("view.dataflow.switchbutton.show"));
        this.graphViewer = new DataflowGraphViewer(this.dfaFrame, 0);
        this.graphViewer.setVisible(false);
        this.tableViewer = new DataflowAnomalyTableViewer(this.dfaFrame, 2048);
        this.tableViewer.addSelectionChangedListener(this);
        this.tableViewer.setContentProvider((IContentProvider)new DataflowAnomalyTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DataflowAnomalyTableLabelProvider());
        this.isTableRefreshed = false;
        GridLayout mainLayout = new GridLayout(2, true);
        mainLayout.horizontalSpacing = 7;
        mainLayout.verticalSpacing = 7;
        mainLayout.marginWidth = 3;
        mainLayout.marginHeight = 3;
        this.dfaFrame.setLayout((Layout)mainLayout);
        this.showTableArea(false);
        this.showFirstMethod();
    }

    public Control getControl() {
        return this.dfaFrame;
    }

    @Override
    protected void showMethod(ASTMethodDeclaration pmdMethod) {
        if (this.textEditor == null) {
            return;
        }
        if (pmdMethod != null) {
            String resourceString = this.getDocument().get();
            this.graphViewer.setVisible(true);
            this.graphViewer.setData((Node)pmdMethod, resourceString);
            this.graphViewer.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    int row = (int)((double)e.y / 49.0);
                    DataflowViewPage.this.graphViewer.getGraph().demark();
                    DataflowViewPage.this.graphViewer.getGraph().markNode(row);
                    DataflowViewPage.this.tableViewer.getTable().deselectAll();
                }
            });
            this.showTableArea(this.isTableShown);
        }
    }

    private void showTableArea(boolean isShown) {
        this.tableViewer.setVisible(isShown);
        if (isShown) {
            ((GridData)this.graphViewer.getLayoutData()).horizontalSpan = 1;
            this.switchButton.setText(DataflowViewPage.getString("view.dataflow.switchbutton.hide"));
            if (!this.isTableRefreshed) {
                this.refreshDFATable(this.getResource());
            }
        } else {
            ((GridData)this.graphViewer.getLayoutData()).horizontalSpan = 2;
            this.switchButton.setText(DataflowViewPage.getString("view.dataflow.switchbutton.show"));
        }
        this.dfaFrame.layout(true, true);
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        if (this.textEditor == null) {
            return;
        }
        RuleViolation violation = this.selectedViolationFrom(event);
        if (violation == null) {
            return;
        }
        String varName = (String)violation.getAdditionalInfo().get("variableName");
        if (StringUtils.isBlank((CharSequence)varName)) {
            return;
        }
        int beginLine = violation.getBeginLine();
        int endLine = violation.getEndLine();
        if (beginLine != 0 && endLine != 0) {
            try {
                int offset = this.getDocument().getLineOffset(violation.getBeginLine() - 1);
                int length = this.getDocument().getLineOffset(violation.getEndLine()) - offset;
                this.highlight(offset, length);
            }
            catch (BadLocationException ble) {
                DataflowViewPage.logError("message.error.runtime_exceptionException when selecting a line in the editor", ble);
            }
            this.showMethodToViolation(violation);
            DataflowGraph graph = this.graphViewer.getGraph();
            if (!this.graphViewer.isDisposed() && graph != null) {
                graph.markPath(beginLine, endLine, varName);
            }
        }
    }

    @Override
    public void refresh(IResource newResource) {
        super.refresh(newResource);
        if (this.isTableShown) {
            this.refreshDFATable(newResource);
        } else {
            this.isTableRefreshed = false;
        }
        this.refreshMethodSelector();
    }

    public void refreshDFATable(IResource newResource) {
        this.isTableRefreshed = true;
    }

    public void propertyChanged(Object source, int propId) {
        if (source instanceof Iterator && propId == 1112) {
            this.tableViewer.setInput(source);
        }
    }
}

