/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.ShapePainter;
import net.sourceforge.pmd.eclipse.ui.preferences.br.CellPainterBuilder;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.util.AbstractCellPainterBuilder;
import net.sourceforge.pmd.lang.rule.Rule;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class Util {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Comparator<Method> METHOD_NAME_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method a, Method b) {
            return a.getName().compareTo(b.getName());
        }
    };
    public static final Comparator<String> COMP_STR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareTo(b);
        }
    };
    public static final Comparator<Integer> COMP_INT = new Comparator<Integer>(){

        @Override
        public int compare(Integer a, Integer b) {
            return a.compareTo(b);
        }
    };
    public static final Comparator<Long> COMP_LONG = new Comparator<Long>(){

        @Override
        public int compare(Long a, Long b) {
            return a.compareTo(b);
        }
    };
    public static final Comparator<Float> COMP_FLOAT = new Comparator<Float>(){

        @Override
        public int compare(Float a, Float b) {
            return a.compareTo(b);
        }
    };
    public static final Comparator<Boolean> COMP_BOOL = new Comparator<Boolean>(){

        @Override
        public int compare(Boolean a, Boolean b) {
            return a.compareTo(b);
        }
    };
    public static final Comparator<Date> COMP_DATE = new Comparator<Date>(){

        @Override
        public int compare(Date a, Date b) {
            return a.compareTo(b);
        }
    };
    public static final Comparator<Character> COMP_CHR = new Comparator<Character>(){

        @Override
        public int compare(Character a, Character b) {
            return a.compareTo(b);
        }
    };

    private Util() {
    }

    public static List<int[]> referencedNamePositionsIn(String source, char prefix) {
        ArrayList<int[]> namePositions = new ArrayList<int[]>();
        if (StringUtils.isBlank((CharSequence)source)) {
            return namePositions;
        }
        int pos = source.indexOf(prefix);
        int max = source.length();
        while (pos >= 0) {
            int end = pos + 1;
            while (end < max && Character.isLetter(source.charAt(end))) {
                ++end;
            }
            int length = end - pos - 1;
            if (length < 1) {
                pos = source.indexOf(prefix, pos + 1);
                continue;
            }
            namePositions.add(new int[]{pos + 1, length});
            pos = source.indexOf(prefix, pos + length);
        }
        return namePositions;
    }

    public static List<String> fragmentsWithin(String source, List<int[]> positions) {
        ArrayList<String> fragments = new ArrayList<String>(positions.size());
        for (int[] position : positions) {
            fragments.add(source.substring(position[0], position[0] + position[1]));
        }
        return fragments;
    }

    public static String signatureFor(Method method, String[] unwantedPrefixes) {
        StringBuilder sb = new StringBuilder();
        Class<?> returnType = method.getReturnType();
        if ("void".equals(returnType.getName())) {
            sb.append("void ");
        } else {
            Util.signatureFor(returnType, unwantedPrefixes, sb);
            sb.append(' ');
        }
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            sb.append(method.getName());
            sb.append("()");
            return sb.toString();
        }
        sb.append(method.getName()).append('(');
        Util.signatureFor(types[0], unwantedPrefixes, sb);
        int i = 1;
        while (i < types.length) {
            sb.append(',');
            Util.signatureFor(types[i], unwantedPrefixes, sb);
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }

    private static String filteredPrefixFrom(String paramType, String[] unwantedPrefixes) {
        String[] stringArray = unwantedPrefixes;
        int n = unwantedPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (paramType.startsWith(prefix)) {
                return paramType.substring(prefix.length());
            }
            ++n2;
        }
        return paramType;
    }

    public static String signatureFor(Class<?> type, String[] unwantedPrefixes) {
        StringBuilder sb = new StringBuilder();
        Util.signatureFor(type, unwantedPrefixes, sb);
        return sb.toString();
    }

    private static void signatureFor(Class<?> type, String[] unwantedPrefixes, StringBuilder sb) {
        String typeName = type.isArray() ? type.getComponentType().getSimpleName() : type.getSimpleName();
        typeName = Util.filteredPrefixFrom(typeName, unwantedPrefixes);
        sb.append(typeName);
        if (type.isArray()) {
            sb.append("[]");
        }
    }

    public static Comparator<Rule> comparatorFrom(final RuleFieldAccessor accessor, final boolean inverted) {
        if (accessor == null) {
            throw new IllegalArgumentException("Accessor is required");
        }
        return new Comparator<Rule>(){

            @Override
            public int compare(Rule a, Rule b) {
                Comparable<?> ca = accessor.valueFor(a);
                Comparable<?> cb = accessor.valueFor(b);
                int result = ca == null ? -1 : (cb == null ? 1 : ca.compareTo(cb));
                return inverted ? result * -1 : result;
            }
        };
    }

    public static void removeListeners(Control widget, int listenerType) {
        Listener[] listenerArray = widget.getListeners(listenerType);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            widget.removeListener(listenerType, listener);
            ++n2;
        }
    }

    public static int indexOf(Object[] items, Object choice) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(choice)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String asCleanString(String original) {
        return original == null ? "" : original.trim();
    }

    public static CellPainterBuilder itemAsShapeFor(final int width, final int height, final Shape shapeId, final int horizAlignment, final Map<Object, RGB> coloursByItem) {
        return new AbstractCellPainterBuilder(){

            private Color getterColorIn(TreeItem tItem, RuleFieldAccessor getter) {
                Object value = this.valueFor(tItem, getter);
                RGB color = (RGB)coloursByItem.get(value);
                return color == null ? null : 10.colorManager().colourFor(color);
            }

            @Override
            public void addPainterFor(final Tree tree, final int columnIndex, final RuleFieldAccessor getter, Map<Integer, List<Listener>> listenersByEventCode) {
                Listener paintListener = new Listener(){

                    public void handleEvent(Event event) {
                        if (event.index != columnIndex) {
                            return;
                        }
                        Color clr = this.getterColorIn((TreeItem)event.item, getter);
                        if (clr == null) {
                            return;
                        }
                        Color original = event.gc.getBackground();
                        event.gc.setBackground(clr);
                        int xOffset = 0;
                        int cellWidth = this.widthOf(columnIndex, tree);
                        switch (horizAlignment) {
                            case 0x1000000: {
                                xOffset = cellWidth / 2 - width / 2 - 3;
                                break;
                            }
                            case 131072: {
                                xOffset = cellWidth - width - 3;
                                break;
                            }
                            case 16384: {
                                xOffset = 0;
                            }
                        }
                        ShapePainter.drawShape(width, height, shapeId, event.gc, event.x + xOffset, event.y, null);
                        event.gc.setBackground(original);
                    }
                };
                Listener measureListener = new Listener(){

                    public void handleEvent(Event e) {
                        if (e.index != columnIndex) {
                            return;
                        }
                        e.width = width;
                        e.height = height;
                    }
                };
                10.addListener((Control)tree, 42, paintListener, listenersByEventCode);
                10.addListener((Control)tree, 41, measureListener, listenersByEventCode);
            }
        };
    }

    public static void addListener(Control control, int eventType, Listener listener, Map<Integer, List<Listener>> listenersByEventCode) {
        Integer eventCode = eventType;
        control.addListener(eventType, listener);
        if (!listenersByEventCode.containsKey(eventCode)) {
            listenersByEventCode.put(eventCode, new ArrayList());
        }
        listenersByEventCode.get(eventCode).add(listener);
    }

    public static CellPainterBuilder backgroundBuilderFor(final int systemColourIndex) {
        return new CellPainterBuilder(){

            @Override
            public void addPainterFor(final Tree tree, final int columnIndex, RuleFieldAccessor getter, Map<Integer, List<Listener>> paintListeners) {
                final Display display = tree.getDisplay();
                tree.addListener(40, new Listener(){

                    public void handleEvent(Event event) {
                        if (event.index != columnIndex) {
                            return;
                        }
                        event.detail &= 0xFFFFFFDF;
                        if ((event.detail & 2) != 0) {
                            int width;
                            GC gc = event.gc;
                            Rectangle area = tree.getClientArea();
                            int columnCount = tree.getColumnCount();
                            if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                                Region region = new Region();
                                gc.getClipping(region);
                                region.add(event.x, event.y, width, event.height);
                                gc.setClipping(region);
                                region.dispose();
                            }
                            gc.setAdvanced(true);
                            if (gc.getAdvanced()) {
                                gc.setAlpha(127);
                            }
                            Rectangle rect = event.getBounds();
                            Color foreground = gc.getForeground();
                            Color background = gc.getBackground();
                            gc.setForeground(display.getSystemColor(systemColourIndex));
                            gc.setBackground(display.getSystemColor(25));
                            gc.fillGradientRectangle(event.x, rect.y, 500, rect.height, false);
                            gc.setForeground(display.getSystemColor(27));
                            gc.drawLine(event.x, rect.y, event.x + 20, rect.y + 20);
                            gc.setForeground(foreground);
                            gc.setBackground(background);
                            event.detail &= 0xFFFFFFFD;
                        }
                    }
                });
            }
        };
    }

    public static CellPainterBuilder textBuilderFor(int systemColourIndex) {
        return new CellPainterBuilder(){

            @Override
            public void addPainterFor(final Tree tree, final int columnIndex, final RuleFieldAccessor getter, Map<Integer, List<Listener>> paintListeners) {
                tree.addListener(42, new Listener(){

                    public void handleEvent(Event event) {
                        int width;
                        if (event.index != columnIndex) {
                            return;
                        }
                        event.detail &= 0xFFFFFFDF;
                        GC gc = event.gc;
                        Rectangle area = tree.getClientArea();
                        Rule rule = (Rule)((TreeItem)event.item).getData();
                        String text = getter.valueFor(rule).toString();
                        int columnCount = tree.getColumnCount();
                        if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                            Region region = new Region();
                            gc.getClipping(region);
                            region.add(event.x, event.y, width, event.height);
                            gc.setClipping(region);
                            region.dispose();
                        }
                        Rectangle rect = event.getBounds();
                        gc.drawString(text, event.x, rect.y);
                    }
                });
            }
        };
    }

    public static String asString(List<String> items, String separator) {
        if (items == null || items.isEmpty()) {
            return "";
        }
        if (items.size() == 1) {
            return items.get(0);
        }
        StringBuilder sb = new StringBuilder(items.get(0));
        int i = 1;
        while (i < items.size()) {
            sb.append(separator).append(items.get(i));
            ++i;
        }
        return sb.toString();
    }

    public static void asString(Object[] items, String separator, StringBuilder target) {
        if (items == null || items.length == 0) {
            return;
        }
        target.append(items[0]);
        int i = 1;
        while (i < items.length) {
            target.append(separator).append(items[i]);
            ++i;
        }
    }
}

