/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.util.internal;

import java.util.Collection;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class SWTUtil {
    public static final String TOOLTIP_SUFFIX = ".tooltip";

    private SWTUtil() {
    }

    public static String stringFor(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    public static String tooltipFor(String key) {
        String tooltip;
        String ttKey = String.valueOf(key) + TOOLTIP_SUFFIX;
        return ttKey.equals(tooltip = SWTUtil.stringFor(ttKey)) ? SWTUtil.stringFor(key) : tooltip;
    }

    public static String[] labelsIn(Object[][] items, int columnIndex) {
        String[] labels = new String[items.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = items[i][columnIndex].toString();
            ++i;
        }
        return labels;
    }

    public static String[] i18lLabelsIn(Object[][] items, int columnIndex) {
        String[] labels = SWTUtil.labelsIn(items, columnIndex);
        int i = 0;
        while (i < labels.length) {
            String xlation = SWTUtil.stringFor(labels[i]);
            labels[i] = xlation == null ? labels[i] : xlation;
            ++i;
        }
        return labels;
    }

    public static void deselectAll(Combo combo) {
        int count = combo.getItems().length;
        int i = 0;
        while (i < count) {
            combo.deselect(i);
            ++i;
        }
    }

    public static void setEnabled(Control control, boolean flag) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(flag);
    }

    public static void setEnabled(Collection<Control> controls, boolean flag) {
        for (Control control : controls) {
            SWTUtil.setEnabled(control, flag);
        }
    }

    public static void setEnabledRecursive(Control[] controls, boolean state) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                SWTUtil.setEnabledRecursive(((Composite)control).getChildren(), state);
            }
            SWTUtil.setEnabled(control, state);
            ++n2;
        }
    }
}

